/*
 * Decompiled with CFR 0.152.
 */
package com.kontakt.sdk.android.ble.cache;

import android.content.Context;
import android.util.TimingLogger;
import com.kontakt.sdk.android.ble.cache.EddystoneResolveRequest;
import com.kontakt.sdk.android.ble.cache.EddystoneUIDResolver;
import com.kontakt.sdk.android.ble.cache.IBeaconIdResolver;
import com.kontakt.sdk.android.ble.cache.IBeaconResolveRequest;
import com.kontakt.sdk.android.ble.cache.SecureProfileResolveRequest;
import com.kontakt.sdk.android.ble.cache.SecureProfileResolver;
import com.kontakt.sdk.android.ble.configuration.ScanContext;
import com.kontakt.sdk.android.ble.discovery.ShuffledDevicesResolver;
import com.kontakt.sdk.android.ble.util.ReplacingArrayList;
import com.kontakt.sdk.android.cloud.KontaktCloud;
import com.kontakt.sdk.android.common.log.Logger;
import com.kontakt.sdk.android.common.model.EddystoneUid;
import com.kontakt.sdk.android.common.model.IBeaconId;
import com.kontakt.sdk.android.common.model.ResolvedId;
import com.kontakt.sdk.android.common.model.SecureProfileUid;
import com.kontakt.sdk.android.common.profile.DeviceProfile;
import com.kontakt.sdk.android.common.profile.IBeaconDevice;
import com.kontakt.sdk.android.common.profile.IEddystoneDevice;
import com.kontakt.sdk.android.common.profile.ISecureProfile;
import com.kontakt.sdk.android.common.profile.RemoteBluetoothDevice;
import com.kontakt.sdk.android.common.util.SDKPreconditions;
import com.kontakt.sdk.android.common.util.SecureProfileUtils;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentSkipListSet;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;

public class FutureShufflesCache {
    private static final String PHANTOM_LABEL = "-PHANTOM-";
    private static final String TAG = "FSCache";
    private static final int DEFAULT_RESOLVER_POOL_SIZE = 2;
    private static final int INITIAL_IBEACON_RESOLVER_DELAY = 1;
    private static final int INITIAL_EDDYSTONE_RESOLVER_DELAY = 2;
    private static final int INITIAL_SECURE_PROFILE_RESOLVER_DELAY = 3;
    public static final ResolvedId PHANTOM_ENTRY = ResolvedId.create("-PHANTOM-", "-PHANTOM-", null);
    private final Map<String, ResolvedId> internalCache = new ConcurrentHashMap<String, ResolvedId>();
    private final List<ShuffledDevicesResolver.ResolveCallback> callbacks = new ReplacingArrayList<ShuffledDevicesResolver.ResolveCallback>();
    private final Set<String> ignored = new ConcurrentSkipListSet<String>();
    private final IBeaconIdResolver iBeaconIdResolver;
    private final EddystoneUIDResolver eddystoneUIDResolver;
    private final SecureProfileResolver secureProfileResolver;
    private final Context context;
    private final ScanContext scanContext;
    private ScheduledExecutorService executorService;
    CacheState state = CacheState.INITIALIZING;

    public FutureShufflesCache(Context context, KontaktCloud kontaktCloud, ScanContext scanContext) {
        this.context = SDKPreconditions.checkNotNull(context);
        this.scanContext = SDKPreconditions.checkNotNull(scanContext);
        this.iBeaconIdResolver = new IBeaconIdResolver(this, kontaktCloud);
        this.eddystoneUIDResolver = new EddystoneUIDResolver(this, kontaktCloud);
        this.secureProfileResolver = new SecureProfileResolver(this, kontaktCloud);
        new DeserializerThread("cache-deserializer-thread").start();
    }

    public void addCallback(ShuffledDevicesResolver.ResolveCallback callback) {
        this.callbacks.add(callback);
    }

    public ResolvedId get(ISecureProfile origin) {
        return this.get(SecureProfileUtils.asRemoteBluetoothDevice(origin));
    }

    public ResolvedId get(RemoteBluetoothDevice origin) {
        switch (origin.getProfile()) {
            case IBEACON: {
                IBeaconDevice iBeaconDevice = (IBeaconDevice)origin;
                String fakeId = IBeaconId.fromDevice(iBeaconDevice).toString();
                return this.get(fakeId);
            }
            case EDDYSTONE: {
                IEddystoneDevice eddystoneDevice = (IEddystoneDevice)origin;
                String fakeUID = EddystoneUid.fromDevice(eddystoneDevice).toString();
                return this.get(fakeUID);
            }
            case KONTAKT_SECURE: {
                ISecureProfile secureProfile = SecureProfileUtils.fromRemoteBluetoothDevice(origin);
                String fakeProfileUID = SecureProfileUid.fromDevice(secureProfile).toString();
                return this.get(fakeProfileUID);
            }
        }
        throw new IllegalArgumentException("Unsupported device profile: " + (Object)((Object)origin.getProfile()));
    }

    public ResolvedId get(String deviceId) {
        if (this.internalCache.containsKey(deviceId)) {
            return this.internalCache.get(deviceId);
        }
        if (this.ignored.contains(deviceId)) {
            return PHANTOM_ENTRY;
        }
        return null;
    }

    public void addResolveRequest(RemoteBluetoothDevice device) {
        this.createResolverRunners();
        switch (device.getProfile()) {
            case IBEACON: {
                IBeaconResolveRequest iBeaconRequest = IBeaconResolveRequest.of(device);
                this.iBeaconIdResolver.addResolveRequest(iBeaconRequest);
                break;
            }
            case EDDYSTONE: {
                EddystoneResolveRequest eddystoneRequest = EddystoneResolveRequest.of(device);
                this.eddystoneUIDResolver.addResolveRequest(eddystoneRequest);
                break;
            }
            case KONTAKT_SECURE: {
                SecureProfileResolveRequest secureProfileRequest = SecureProfileResolveRequest.of(device);
                this.secureProfileResolver.addResolveRequest(secureProfileRequest);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported device profile: " + (Object)((Object)device.getProfile()));
            }
        }
    }

    void evict(List<String> uniqueIds, DeviceProfile deviceProfile) {
        Iterator<Map.Entry<String, ResolvedId>> cacheIterator = this.internalCache.entrySet().iterator();
        while (cacheIterator.hasNext()) {
            Map.Entry<String, ResolvedId> entry = cacheIterator.next();
            ResolvedId evictCandidate = entry.getValue();
            if (!uniqueIds.contains(evictCandidate.getUniqueId()) || deviceProfile != evictCandidate.getDeviceProfile()) continue;
            cacheIterator.remove();
        }
    }

    void createResolverRunners() {
        if (this.executorService == null) {
            this.executorService = Executors.newScheduledThreadPool(2);
            this.executorService.scheduleWithFixedDelay(this.iBeaconIdResolver, 1L, this.scanContext.getResolveInterval(), TimeUnit.SECONDS);
            this.executorService.scheduleWithFixedDelay(this.eddystoneUIDResolver, 2L, this.scanContext.getResolveInterval(), TimeUnit.SECONDS);
            this.executorService.scheduleWithFixedDelay(this.secureProfileResolver, 3L, this.scanContext.getResolveInterval(), TimeUnit.SECONDS);
        }
    }

    public void finishResolveRunners() {
        if (this.executorService != null) {
            this.executorService.shutdownNow();
            this.executorService = null;
        }
    }

    public CacheState getState() {
        return this.state;
    }

    public boolean isInitialized() {
        return CacheState.INITIALIZED == this.state;
    }

    void populate(String deviceId, ResolvedId resolvedId) {
        if (PHANTOM_ENTRY.equals(resolvedId)) {
            this.ignored.add(deviceId);
        } else {
            this.internalCache.put(deviceId, resolvedId);
        }
    }

    void notifyListeners(RemoteBluetoothDevice device) {
        for (ShuffledDevicesResolver.ResolveCallback callback : this.callbacks) {
            callback.onResolved(device);
        }
    }

    synchronized void serialize() {
        try {
            TimingLogger timings = new TimingLogger(TAG, "Serialization");
            FileOutputStream fos = this.context.openFileOutput(this.scanContext.getCacheFileName(), 0);
            BufferedOutputStream bos = new BufferedOutputStream(fos);
            ObjectOutputStream os = new ObjectOutputStream(fos);
            os.writeObject(this.internalCache);
            os.close();
            bos.close();
            fos.close();
            Logger.d("FSCache Cached size: " + this.internalCache.size());
            timings.addSplit("Save file");
            timings.dumpToLog();
        }
        catch (IOException e) {
            Logger.e("FSCache Error when try to serialize cache: ", e);
        }
    }

    void deserialize() {
        try {
            TimingLogger timings = new TimingLogger(TAG, "Deserialization");
            FileInputStream fis = this.context.openFileInput(this.scanContext.getCacheFileName());
            BufferedInputStream bis = new BufferedInputStream(fis);
            ObjectInputStream ois = new ObjectInputStream(bis);
            ConcurrentHashMap cached = (ConcurrentHashMap)ois.readObject();
            ois.close();
            bis.close();
            fis.close();
            Logger.d("FSCache Cached size: " + cached.size());
            this.internalCache.putAll(cached);
            timings.addSplit("Read file");
            timings.dumpToLog();
        }
        catch (FileNotFoundException e) {
            Logger.d("FSCache Cache file not found: " + e.getMessage());
        }
        catch (IOException | ClassNotFoundException e) {
            Logger.e("FSCache Error when try to deserialize cache: ", e);
        }
    }

    public void clear() {
        this.finishResolveRunners();
        this.internalCache.clear();
        this.clearBuffers();
        File cache = new File(this.context.getFilesDir(), this.scanContext.getCacheFileName());
        if (!cache.exists()) {
            return;
        }
        String deleted = cache.delete() ? "Success" : "Failure";
        Logger.d("FSCacheDeleting cache file... " + deleted);
    }

    public synchronized void clearBuffers() {
        this.ignored.clear();
        this.iBeaconIdResolver.clear();
        this.eddystoneUIDResolver.clear();
        this.secureProfileResolver.clear();
        Logger.d("FSCacheCleared internal buffers");
    }

    public void markIgnored(RemoteBluetoothDevice beacon) {
        switch (beacon.getProfile()) {
            case IBEACON: {
                this.iBeaconIdResolver.markIgnored(beacon);
                break;
            }
            case EDDYSTONE: {
                this.eddystoneUIDResolver.markIgnored(beacon);
                break;
            }
            case KONTAKT_SECURE: {
                this.secureProfileResolver.markIgnored(beacon);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported device profile: " + (Object)((Object)beacon.getProfile()));
            }
        }
    }

    private class DeserializerThread
    extends Thread {
        DeserializerThread(String name) {
            super(name);
        }

        @Override
        public void run() {
            FutureShufflesCache.this.deserialize();
            FutureShufflesCache.this.state = CacheState.INITIALIZED;
        }
    }

    private static enum CacheState {
        INITIALIZING,
        INITIALIZED;

    }
}

