package com.kontakt.sdk.android.common.model;

import android.os.Parcel;
import android.os.Parcelable;

/**
 * Model class that provides information about geographic coordinates - 4 [lat, lng] points.
 */
public class GeoCoordinates implements Coordinates {

  /**
   * Parcelable CREATOR constant.
   */
  public static final Parcelable.Creator<GeoCoordinates> CREATOR = new Parcelable.Creator<GeoCoordinates>() {
    @Override
    public GeoCoordinates createFromParcel(Parcel source) {
      return new GeoCoordinates(source);
    }

    @Override
    public GeoCoordinates[] newArray(int size) {
      return new GeoCoordinates[size];
    }
  };

  private final double x1;
  private final double y1;

  private final double x2;
  private final double y2;

  private final double x3;
  private final double y3;

  private final double x4;
  private final double y4;

  public GeoCoordinates(double x1, double y1, double x2, double y2, double x3, double y3, double x4, double y4) {
    this.x1 = x1;
    this.y1 = y1;
    this.x2 = x2;
    this.y2 = y2;
    this.x3 = x3;
    this.y3 = y3;
    this.x4 = x4;
    this.y4 = y4;
  }

  protected GeoCoordinates(Parcel in) {
    this.x1 = in.readDouble();
    this.y1 = in.readDouble();
    this.x2 = in.readDouble();
    this.y2 = in.readDouble();
    this.x3 = in.readDouble();
    this.y3 = in.readDouble();
    this.x4 = in.readDouble();
    this.y4 = in.readDouble();
  }

  @Override
  public Type getType() {
    return Type.GEO;
  }

  @Override
  public String toString() {
    return x1 + ":" + y1 + "," + x2 + ":" + y2 + "," + x3 + ":" + y3 + "," + x4 + ":" + y4;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;

    GeoCoordinates that = (GeoCoordinates) o;

    if (Double.compare(that.x1, x1) != 0) return false;
    if (Double.compare(that.y1, y1) != 0) return false;
    if (Double.compare(that.x2, x2) != 0) return false;
    if (Double.compare(that.y2, y2) != 0) return false;
    if (Double.compare(that.x3, x3) != 0) return false;
    if (Double.compare(that.y3, y3) != 0) return false;
    if (Double.compare(that.x4, x4) != 0) return false;
    return Double.compare(that.y4, y4) == 0;
  }

  @Override
  public int hashCode() {
    int result;
    long temp;
    temp = Double.doubleToLongBits(x1);
    result = (int) (temp ^ (temp >>> 32));
    temp = Double.doubleToLongBits(y1);
    result = 31 * result + (int) (temp ^ (temp >>> 32));
    temp = Double.doubleToLongBits(x2);
    result = 31 * result + (int) (temp ^ (temp >>> 32));
    temp = Double.doubleToLongBits(y2);
    result = 31 * result + (int) (temp ^ (temp >>> 32));
    temp = Double.doubleToLongBits(x3);
    result = 31 * result + (int) (temp ^ (temp >>> 32));
    temp = Double.doubleToLongBits(y3);
    result = 31 * result + (int) (temp ^ (temp >>> 32));
    temp = Double.doubleToLongBits(x4);
    result = 31 * result + (int) (temp ^ (temp >>> 32));
    temp = Double.doubleToLongBits(y4);
    result = 31 * result + (int) (temp ^ (temp >>> 32));
    return result;
  }

  @Override
  public int describeContents() {
    return 0;
  }

  @Override
  public void writeToParcel(Parcel dest, int flags) {
    dest.writeDouble(this.x1);
    dest.writeDouble(this.y1);
    dest.writeDouble(this.x2);
    dest.writeDouble(this.y2);
    dest.writeDouble(this.x3);
    dest.writeDouble(this.y3);
    dest.writeDouble(this.x4);
    dest.writeDouble(this.y4);
  }

  public double getX1() {
    return x1;
  }

  public double getY1() {
    return y1;
  }

  public double getX2() {
    return x2;
  }

  public double getY2() {
    return y2;
  }

  public double getX3() {
    return x3;
  }

  public double getY3() {
    return y3;
  }

  public double getX4() {
    return x4;
  }

  public double getY4() {
    return y4;
  }
}
