package com.kontakt.sdk.android.ble.connection;

/**
 * {@link KontaktDeviceConnection} possible errors.
 */
public class DeviceConnectionError {

  /**
   * Error code informing that Beacon services discovery has failed.
   */
  public static final int ERROR_SERVICES_DISCOVERY = 1;

  /**
   * Error code informing that error has occured during characteristic
   * overwrite process.
   */
  public static final int ERROR_OVERWRITE_REQUEST = 2;

  /**
   * Error code informing that unexpected error has occured while attempting
   * beacon authentication.
   */
  public static final int ERROR_AUTHENTICATION = 3;

  /**
   * Failure code informing that BLE device was not recognised as kontakt.io
   * Beacon.
   */
  public static final int FAILURE_UNKNOWN_BEACON = 4;

  /**
   * Failure code informing that beacon was not authenticated because of
   * wrong password. When authentication failure occurs, beacon change its
   * state to Non-connectable mode lasting about 20 minutes.
   */
  public static final int FAILURE_WRONG_PASSWORD = 7;

  /**
   * Error code informing that Batch write operation failed during Proximity UUID write.
   */
  public static final int ERROR_BATCH_WRITE_PROXIMITY_UUID = 8;

  /**
   * Error code informing that Batch write operation failed during Transmission Power write.
   */
  public static final int ERROR_BATCH_WRITE_TX_POWER = 9;

  /**
   * Error code informing that Batch write operation failed during Major write.
   */
  public static final int ERROR_BATCH_WRITE_MAJOR = 10;

  /**
   * Error code informing that Batch write operation failed during Minor write.
   */
  public static final int ERROR_BATCH_WRITE_MINOR = 11;

  /**
   * Error code informing that Batch write operation failed during Interval write.
   */
  public static final int ERROR_BATCH_WRITE_INTERVAL = 12;

  /**
   * Error code informing that Batch write operation failed during Profile write
   */
  public static final int ERROR_BATCH_WRITE_PROFILE = 13;

  /**
   * Error code informing that Batch write operation failed during Namespace write
   */
  public static final int ERROR_BATCH_WRITE_NAMESPACE = 14;

  /**
   * Error code informing that Batch write operation failed during InstanceId write
   */
  public static final int ERROR_BATCH_WRITE_INSTANCE_ID = 15;

  /**
   * Error code informing that Batch write operation failed during Url write
   */
  public static final int ERROR_BATCH_WRITE_URL = 16;

  /**
   * Error code informing that Batch write operation failed during Name write
   */
  public static final int ERROR_BATCH_WRITE_NAME = 17;

  /**
   * Error code informing that Batch write failed during Password write
   */
  public static final int ERROR_BATCH_WRITE_PASSWORD = 18;

  static final int GATT_ERROR_BEGIN = 1000;

  /**
   * Metohd for checking is error code indicating GATT error
   *
   * @param errorCode received from {@link KontaktDeviceConnection.ConnectionListener#onErrorOccured(int)}
   * @return true if errorCode is gatt error
   */
  public static boolean isGattError(int errorCode) {
    return errorCode > GATT_ERROR_BEGIN;
  }

  /**
   * Method for getting gatt error status code from received errorCode
   * <br><br> throws {@link IllegalAccessException} if errorCode is not gatt error code
   *
   * @param errorCode error code
   * @return Gatt status code, e.g 133
   */
  public static int getGattError(int errorCode) {
    if (!isGattError(errorCode)) {
      throw new IllegalArgumentException("Error code is not gatt error");
    }
    return errorCode - GATT_ERROR_BEGIN;
  }

  static int toGattError(int errorCode) {
    return errorCode + GATT_ERROR_BEGIN;
  }

}
