/*
 * Decompiled with CFR 0.152.
 */
package com.kontakt.sdk.android.cloud.api.executor.firmwares;

import com.kontakt.sdk.android.cloud.api.executor.RequestExecutor;
import com.kontakt.sdk.android.cloud.api.service.FirmwaresService;
import com.kontakt.sdk.android.cloud.exception.KontaktCloudException;
import com.kontakt.sdk.android.cloud.response.CloudCallback;
import com.kontakt.sdk.android.cloud.util.StringUtils;
import com.kontakt.sdk.android.common.util.SDKPreconditions;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import retrofit2.Call;

public class ScheduleFirmwareUpdateRequestExecutor
extends RequestExecutor<String> {
    private final FirmwaresService firmwaresService;
    private String[] deviceUniqueIds;
    private String name;

    public ScheduleFirmwareUpdateRequestExecutor(FirmwaresService firmwaresService) {
        this.firmwaresService = firmwaresService;
    }

    public ScheduleFirmwareUpdateRequestExecutor forDevices(String ... deviceUniqueIds) {
        this.deviceUniqueIds = SDKPreconditions.checkNotNull(deviceUniqueIds, "IDs cannot be null");
        return this;
    }

    public ScheduleFirmwareUpdateRequestExecutor forDevices(List<String> deviceUniqueIds) {
        SDKPreconditions.checkNotNull(deviceUniqueIds, "IDs cannot be null");
        int size = deviceUniqueIds.size();
        this.deviceUniqueIds = deviceUniqueIds.toArray(new String[size]);
        return this;
    }

    public ScheduleFirmwareUpdateRequestExecutor withVersion(String name) {
        this.name = SDKPreconditions.checkNotNull(name, "name cannot be null");
        return this;
    }

    @Override
    public String execute() throws IOException, KontaktCloudException {
        this.checkPreconditions();
        return (String)super.execute();
    }

    @Override
    public void execute(CloudCallback<String> callback) {
        this.checkPreconditions();
        super.execute(callback);
    }

    @Override
    protected Call<String> prepareCall() {
        return this.firmwaresService.scheduleFirmwareUpdate(this.params());
    }

    private void checkPreconditions() {
        SDKPreconditions.checkState(this.deviceUniqueIds != null, "specify devices");
        SDKPreconditions.checkState(this.name != null, "specify firmware version name");
    }

    @Override
    protected Map<String, String> params() {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("uniqueId", StringUtils.join(this.deviceUniqueIds, ","));
        params.put("name", this.name);
        return params;
    }
}

