/*
 * Decompiled with CFR 0.152.
 */
package com.kontakt.sdk.android.ble.service;

import android.annotation.TargetApi;
import android.bluetooth.BluetoothAdapter;
import android.bluetooth.le.BluetoothLeScanner;
import android.bluetooth.le.ScanCallback;
import android.bluetooth.le.ScanFilter;
import android.bluetooth.le.ScanSettings;
import com.kontakt.sdk.android.ble.cache.FutureShufflesCache;
import com.kontakt.sdk.android.ble.configuration.ForceScanConfiguration;
import com.kontakt.sdk.android.ble.configuration.ScanContext;
import com.kontakt.sdk.android.ble.monitoring.IEventCollector;
import com.kontakt.sdk.android.ble.service.BleScanCallback;
import com.kontakt.sdk.android.ble.service.ForceScanScheduler;
import com.kontakt.sdk.android.ble.service.MonitorCallback;
import com.kontakt.sdk.android.ble.service.MonitorCallbackL;
import com.kontakt.sdk.android.ble.service.Runners;
import com.kontakt.sdk.android.ble.service.RunnersL;
import com.kontakt.sdk.android.ble.service.ScanCompat;
import com.kontakt.sdk.android.ble.service.ScanConfiguration;
import com.kontakt.sdk.android.ble.service.ScanConfigurationL;
import com.kontakt.sdk.android.ble.service.ScanController;
import com.kontakt.sdk.android.common.log.Logger;
import com.kontakt.sdk.android.common.util.Closeables;
import java.util.ArrayList;
import java.util.List;

@TargetApi(value=21)
final class ScanCompatL
extends ScanCompat {
    private static final List<ScanFilter> EMPTY_SCAN_FILTERS = new ArrayList<ScanFilter>();

    ScanCompatL() {
    }

    @Override
    public ScanConfiguration createScanConfiguration(ScanContext scanContext, FutureShufflesCache cache, IEventCollector eventCollector) {
        MonitorCallback callback = MonitorCallback.create(scanContext, cache, eventCollector);
        MonitorCallbackL callbackL = MonitorCallbackL.wrap(callback);
        final ScanSettings scanSettings = new ScanSettings.Builder().setScanMode(scanContext.getScanMode().getCode()).build();
        return new ScanCompat.AbstractScanConfigurationL(scanContext, callbackL){

            @Override
            public ScanSettings getScanSettings() {
                return scanSettings;
            }
        };
    }

    @Override
    public ScanController createScanController(ScanConfiguration configuration, ForceScanScheduler forceScanScheduler) {
        return new ScanController.Builder().setScanPeriod(configuration.getScanContext().getScanPeriod()).setScanActiveRunner(RunnersL.newRunner(Runners.RunnerType.MONITOR_ACTIVE_RUNNER, configuration)).setScanPassiveRunner(RunnersL.newRunner(Runners.RunnerType.MONITOR_PASSIVE_RUNNER, configuration)).setForceScanScheduler(forceScanScheduler).build();
    }

    @Override
    public ForceScanScheduler createForceScanScheduler(ScanConfiguration configuration) {
        ScanContext scanContext = configuration.getScanContext();
        if (scanContext.getForceScanConfiguration() == ForceScanConfiguration.DISABLED) {
            return ForceScanScheduler.DISABLED;
        }
        return new ForceScanScheduler(RunnersL.newRunner(Runners.RunnerType.FORCE_SCAN_RUNNER, configuration));
    }

    @Override
    public void onScanStart(ScanConfiguration configuration) {
        ScanConfigurationL scanConfiguration = (ScanConfigurationL)configuration;
        ScanSettings scanSettings = scanConfiguration.getScanSettings();
        ScanCallback scanCallback = (ScanCallback)scanConfiguration.getScanCallback();
        BluetoothLeScanner scanner = ScanCompatL.getScanner();
        if (scanner != null) {
            scanner.startScan(EMPTY_SCAN_FILTERS, scanSettings, scanCallback);
        } else {
            Logger.e("onRangingStart(): BluetoothLeScanner is null.");
        }
    }

    @Override
    public void onScanStop(BleScanCallback callback) {
        if (callback != null) {
            ScanCallback scanCallback = (ScanCallback)callback;
            BluetoothLeScanner scanner = ScanCompatL.getScanner();
            if (scanner != null) {
                scanner.flushPendingScanResults(scanCallback);
                scanner.stopScan(scanCallback);
            }
            Closeables.closeQuietly(callback);
        }
    }

    @TargetApi(value=21)
    private static BluetoothLeScanner getScanner() {
        BluetoothAdapter adapter = BluetoothAdapter.getDefaultAdapter();
        if (adapter != null) {
            return adapter.getBluetoothLeScanner();
        }
        return null;
    }
}

