/*
 * Decompiled with CFR 0.152.
 */
package com.kontakt.sdk.android.ble.service;

import android.bluetooth.BluetoothDevice;
import android.os.Handler;
import com.kontakt.sdk.android.ble.cache.FutureShufflesCache;
import com.kontakt.sdk.android.ble.configuration.ActivityCheckConfiguration;
import com.kontakt.sdk.android.ble.configuration.ScanContext;
import com.kontakt.sdk.android.ble.configuration.ScanPeriod;
import com.kontakt.sdk.android.ble.discovery.BluetoothDeviceDiscoverer;
import com.kontakt.sdk.android.ble.discovery.BluetoothDeviceEvent;
import com.kontakt.sdk.android.ble.discovery.DiscoveryContract;
import com.kontakt.sdk.android.ble.discovery.EventType;
import com.kontakt.sdk.android.ble.manager.listeners.InternalProximityListener;
import com.kontakt.sdk.android.ble.monitoring.IEventCollector;
import com.kontakt.sdk.android.ble.service.BleScanCallback;
import com.kontakt.sdk.android.ble.service.DefaultBluetoothDeviceDiscoverer;
import com.kontakt.sdk.android.common.KontaktSDK;
import com.kontakt.sdk.android.common.log.Logger;
import com.kontakt.sdk.android.common.profile.RemoteBluetoothDevice;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

abstract class MonitorCallback
implements BleScanCallback,
DiscoveryContract {
    final BluetoothDeviceDiscoverer bluetoothDeviceDiscoverer;
    private final Handler handler = new Handler();
    private final Map<Integer, InternalProximityListener> monitoringListenerMap = new ConcurrentHashMap<Integer, InternalProximityListener>();
    private final ActivityCheckConfiguration activityCheckConfiguration;
    private final ScanPeriod scanPeriod;
    private final IEventCollector eventCollector;
    private final Runnable periodicActivityCheckRunnable = new Runnable(){

        @Override
        public void run() {
            MonitorCallback.this.evictInactiveDevices(System.currentTimeMillis());
        }
    };

    static MonitorCallback create(ScanContext scanContext, FutureShufflesCache cache, IEventCollector eventCollector) {
        return new MonitorCallback(scanContext, cache, eventCollector){};
    }

    private MonitorCallback(ScanContext scanContext, FutureShufflesCache cache, IEventCollector eventCollector) {
        this.eventCollector = eventCollector;
        this.bluetoothDeviceDiscoverer = new DefaultBluetoothDeviceDiscoverer(scanContext, this, cache);
        this.activityCheckConfiguration = scanContext.getActivityCheckConfiguration();
        this.scanPeriod = scanContext.getScanPeriod();
    }

    public void onLeScan(BluetoothDevice device, int rssi, byte[] scanRecord) {
        if (!this.isAnyListenerRegistered() && KontaktSDK.isInitialized()) {
            return;
        }
        if (device == null) {
            Logger.d("Remote device discovered but is null");
            return;
        }
        Logger.d(String.format("Device discovered: %s Payload: %s RSSI: %d", device.toString(), Arrays.toString(scanRecord), rssi));
        this.performDiscovery(device, rssi, scanRecord);
    }

    private void performDiscovery(final BluetoothDevice device, final int rssi, final byte[] scanRecord) {
        this.handler.post(new Runnable(){

            @Override
            public void run() {
                MonitorCallback.this.bluetoothDeviceDiscoverer.performDiscovery(device, rssi, scanRecord);
            }
        });
    }

    @Override
    public void addListener(InternalProximityListener proximityListener) {
        int hashCode = System.identityHashCode(proximityListener);
        InternalProximityListener insertion = this.monitoringListenerMap.put(hashCode, proximityListener);
        if (insertion == null) {
            Logger.d("MonitoringListener registered: " + hashCode);
        }
    }

    @Override
    public void removeListener(InternalProximityListener proximityListener) {
        int hashCode = System.identityHashCode(proximityListener);
        InternalProximityListener deletion = this.monitoringListenerMap.remove(hashCode);
        if (deletion != null) {
            Logger.d("MonitoringListener unregistered: " + hashCode);
        }
    }

    @Override
    public Collection<InternalProximityListener> getMonitoringListeners() {
        return Collections.unmodifiableCollection(new ArrayList<InternalProximityListener>(this.monitoringListenerMap.values()));
    }

    @Override
    public void onMonitorCycleStart() {
        if (this.scanPeriod != ScanPeriod.RANGING) {
            for (InternalProximityListener proximityListener : this.monitoringListenerMap.values()) {
                proximityListener.onMonitoringCycleStart();
            }
        }
        this.handler.post(new Runnable(){

            @Override
            public void run() {
                MonitorCallback.this.startPeriodicInactivityCheck();
            }
        });
    }

    @Override
    public void onMonitorCycleStop() {
        if (this.scanPeriod != ScanPeriod.RANGING) {
            for (InternalProximityListener proximityListener : this.monitoringListenerMap.values()) {
                proximityListener.onMonitoringCycleStop();
            }
        }
        this.handler.post(new Runnable(){

            @Override
            public void run() {
                MonitorCallback.this.stopPeriodicInactivityCheck();
            }
        });
    }

    @Override
    public void onEvent(BluetoothDeviceEvent event) {
        for (InternalProximityListener proximityListener : this.monitoringListenerMap.values()) {
            proximityListener.onEvent(event);
        }
        this.collectEvent(event);
    }

    private void collectEvent(BluetoothDeviceEvent event) {
        EventType type = event.getEventType();
        if (type == EventType.DEVICE_DISCOVERED || type == EventType.DEVICES_UPDATE) {
            List<? extends RemoteBluetoothDevice> devices = event.getDeviceList();
            for (RemoteBluetoothDevice remoteBluetoothDevice : devices) {
                this.eventCollector.collect(remoteBluetoothDevice);
            }
        }
    }

    void startPeriodicInactivityCheck() {
        if (this.activityCheckConfiguration.equals(ActivityCheckConfiguration.DISABLED)) {
            return;
        }
        long checkPeriod = this.activityCheckConfiguration.getCheckPeriod();
        this.handler.postDelayed(this.periodicActivityCheckRunnable, checkPeriod);
    }

    void stopPeriodicInactivityCheck() {
        if (this.activityCheckConfiguration == ActivityCheckConfiguration.DISABLED) {
            return;
        }
        this.handler.removeCallbacksAndMessages(null);
    }

    void evictInactiveDevices(long currentTimeMillis) {
        this.bluetoothDeviceDiscoverer.evictInactiveDevices(currentTimeMillis);
        this.startPeriodicInactivityCheck();
    }

    private boolean isAnyListenerRegistered() {
        return !this.monitoringListenerMap.isEmpty();
    }

    @Override
    public void close() {
        this.eventCollector.stop();
        this.eventCollector.clear();
        this.bluetoothDeviceDiscoverer.disable();
        this.monitoringListenerMap.clear();
        this.handler.removeCallbacksAndMessages(null);
    }
}

