/*
 * Decompiled with CFR 0.152.
 */
package com.kontakt.sdk.android.ble.manager;

import android.os.Handler;
import com.kontakt.sdk.android.ble.discovery.BluetoothDeviceEvent;
import com.kontakt.sdk.android.ble.discovery.eddystone.EddystoneDeviceEvent;
import com.kontakt.sdk.android.ble.discovery.ibeacon.IBeaconDeviceEvent;
import com.kontakt.sdk.android.ble.discovery.secure_profile.SecureProfileEvent;
import com.kontakt.sdk.android.ble.exception.ScanError;
import com.kontakt.sdk.android.ble.manager.listeners.EddystoneListener;
import com.kontakt.sdk.android.ble.manager.listeners.IBeaconListener;
import com.kontakt.sdk.android.ble.manager.listeners.InternalProximityListener;
import com.kontakt.sdk.android.ble.manager.listeners.ScanStatusListener;
import com.kontakt.sdk.android.ble.manager.listeners.SecureProfileListener;
import com.kontakt.sdk.android.ble.manager.listeners.SpaceListener;
import com.kontakt.sdk.android.common.profile.IBeaconDevice;
import com.kontakt.sdk.android.common.profile.IEddystoneDevice;
import java.util.List;

class EventObserver
implements InternalProximityListener {
    private final Handler handler = new Handler();
    final ScanStatusListener scanStatusListener;
    final SpaceListener spaceListener;
    final EddystoneListener eddystoneListener;
    final IBeaconListener iBeaconListener;
    final SecureProfileListener secureProfileListener;

    EventObserver(EddystoneListener eddystoneListener, IBeaconListener iBeaconListener, ScanStatusListener scanStatusListener, SpaceListener spaceListener, SecureProfileListener secureProfileListener) {
        this.iBeaconListener = iBeaconListener;
        this.eddystoneListener = eddystoneListener;
        this.scanStatusListener = scanStatusListener;
        this.spaceListener = spaceListener;
        this.secureProfileListener = secureProfileListener;
    }

    @Override
    public void onScanStart() {
        this.handler.post(new Runnable(){

            @Override
            public void run() {
                if (EventObserver.this.scanStatusListener != null) {
                    EventObserver.this.scanStatusListener.onScanStart();
                }
            }
        });
    }

    @Override
    public void onScanStop() {
        this.handler.post(new Runnable(){

            @Override
            public void run() {
                if (EventObserver.this.scanStatusListener != null) {
                    EventObserver.this.scanStatusListener.onScanStop();
                }
            }
        });
    }

    @Override
    public void onMonitoringCycleStart() {
        this.handler.post(new Runnable(){

            @Override
            public void run() {
                if (EventObserver.this.scanStatusListener != null) {
                    EventObserver.this.scanStatusListener.onMonitoringCycleStart();
                }
            }
        });
    }

    @Override
    public void onMonitoringCycleStop() {
        this.handler.post(new Runnable(){

            @Override
            public void run() {
                if (EventObserver.this.scanStatusListener != null) {
                    EventObserver.this.scanStatusListener.onMonitoringCycleStop();
                }
            }
        });
    }

    @Override
    public void onScanError(final ScanError exception) {
        this.handler.post(new Runnable(){

            @Override
            public void run() {
                if (EventObserver.this.scanStatusListener != null) {
                    EventObserver.this.scanStatusListener.onScanError(exception);
                }
            }
        });
    }

    @Override
    public void onEvent(final BluetoothDeviceEvent event) {
        this.handler.post(new Runnable(){

            @Override
            public void run() {
                if (event instanceof EddystoneDeviceEvent) {
                    EventObserver.this.onEddystoneEvent((EddystoneDeviceEvent)event);
                } else if (event instanceof IBeaconDeviceEvent) {
                    EventObserver.this.onIBeaconEvent((IBeaconDeviceEvent)event);
                } else if (event instanceof SecureProfileEvent) {
                    EventObserver.this.onSecureProfileEvent((SecureProfileEvent)event);
                }
            }
        });
    }

    void onEddystoneEvent(EddystoneDeviceEvent event) {
        switch (event.getEventType()) {
            case DEVICE_DISCOVERED: 
            case DEVICES_UPDATE: 
            case DEVICE_LOST: {
                this.invokeDeviceCallbacks(event);
                break;
            }
            case SPACE_ENTERED: 
            case SPACE_ABANDONED: {
                this.invokeSpaceCallbacks(event);
            }
        }
    }

    void onIBeaconEvent(IBeaconDeviceEvent event) {
        switch (event.getEventType()) {
            case DEVICE_DISCOVERED: 
            case DEVICES_UPDATE: 
            case DEVICE_LOST: {
                this.invokeDeviceCallbacks(event);
                break;
            }
            case SPACE_ENTERED: 
            case SPACE_ABANDONED: {
                this.invokeSpaceCallbacks(event);
            }
        }
    }

    void onSecureProfileEvent(SecureProfileEvent event) {
        if (this.secureProfileListener == null) {
            return;
        }
        switch (event.getEventType()) {
            case DEVICE_DISCOVERED: {
                this.secureProfileListener.onProfileDiscovered(event.getSecureProfileDevices().get(0));
                break;
            }
            case DEVICES_UPDATE: {
                this.secureProfileListener.onProfilesUpdated(event.getSecureProfileDevices());
                break;
            }
            case DEVICE_LOST: {
                this.secureProfileListener.onProfileLost(event.getSecureProfileDevices().get(0));
            }
        }
    }

    private void invokeDeviceCallbacks(EddystoneDeviceEvent event) {
        if (this.eddystoneListener == null) {
            return;
        }
        List<IEddystoneDevice> deviceList = event.getDeviceList();
        switch (event.getEventType()) {
            case DEVICE_DISCOVERED: {
                this.eddystoneListener.onEddystoneDiscovered(deviceList.get(0), event.getNamespace());
                break;
            }
            case DEVICES_UPDATE: {
                this.eddystoneListener.onEddystonesUpdated(deviceList, event.getNamespace());
                break;
            }
            case DEVICE_LOST: {
                this.eddystoneListener.onEddystoneLost(deviceList.get(0), event.getNamespace());
            }
        }
    }

    private void invokeDeviceCallbacks(IBeaconDeviceEvent event) {
        if (this.iBeaconListener == null) {
            return;
        }
        List<IBeaconDevice> deviceList = event.getDeviceList();
        switch (event.getEventType()) {
            case DEVICE_DISCOVERED: {
                this.iBeaconListener.onIBeaconDiscovered(deviceList.get(0), event.getRegion());
                break;
            }
            case DEVICES_UPDATE: {
                this.iBeaconListener.onIBeaconsUpdated(deviceList, event.getRegion());
                break;
            }
            case DEVICE_LOST: {
                this.iBeaconListener.onIBeaconLost(deviceList.get(0), event.getRegion());
            }
        }
    }

    private void invokeSpaceCallbacks(EddystoneDeviceEvent event) {
        if (this.spaceListener == null) {
            return;
        }
        switch (event.getEventType()) {
            case SPACE_ENTERED: {
                this.spaceListener.onNamespaceEntered(event.getNamespace());
                break;
            }
            case SPACE_ABANDONED: {
                this.spaceListener.onNamespaceAbandoned(event.getNamespace());
            }
        }
    }

    private void invokeSpaceCallbacks(IBeaconDeviceEvent event) {
        if (this.spaceListener == null) {
            return;
        }
        switch (event.getEventType()) {
            case SPACE_ENTERED: {
                this.spaceListener.onRegionEntered(event.getRegion());
                break;
            }
            case SPACE_ABANDONED: {
                this.spaceListener.onRegionAbandoned(event.getRegion());
            }
        }
    }
}

