/*
 * Decompiled with CFR 0.152.
 */
package com.kontakt.sdk.android.ble.discovery.eddystone;

import com.kontakt.sdk.android.ble.discovery.eddystone.EddystonePropertyResolver;
import com.kontakt.sdk.android.ble.spec.Telemetry;
import com.kontakt.sdk.android.common.util.ConversionUtils;

final class TLMResolver
implements EddystonePropertyResolver<Telemetry> {
    private static final int TLM_START_INDEX = 3;
    private static final int SCAN_RECORD_TLM_LENGTH = 13;

    TLMResolver() {
    }

    @Override
    public Telemetry parse(byte[] packet) throws IllegalArgumentException {
        if (packet == null) {
            return null;
        }
        byte[] bytes = ConversionUtils.extractEddystonePacketPayload(packet, 3, 13);
        if (bytes == null) {
            return null;
        }
        int version = bytes[0] & 0xFF;
        byte[] batteryVoltage = new byte[]{bytes[1], bytes[2]};
        int batteryVoltageValue = ConversionUtils.asInt(batteryVoltage);
        byte[] tempVoltage = new byte[]{bytes[3], bytes[4]};
        double tempVoltageValue = (double)ConversionUtils.asInt(tempVoltage) * 1.0 / 256.0;
        byte[] advertisingPduCount = new byte[]{bytes[5], bytes[6], bytes[7], bytes[8]};
        int advertisingPduCountValue = ConversionUtils.asInt(advertisingPduCount);
        byte[] timeSincePowerUp = new byte[]{bytes[9], bytes[10], bytes[11], bytes[12]};
        int timeSincePowerUpValue = ConversionUtils.asInt(timeSincePowerUp) / 10;
        return new Telemetry.Builder().batteryVoltage(batteryVoltageValue).temperature(tempVoltageValue).timeSincePowerUp(timeSincePowerUpValue).pduCount(advertisingPduCountValue).version(version).build();
    }
}

