/*
 * Decompiled with CFR 0.152.
 */
package com.kontakt.sdk.android.ble.device;

import android.os.Parcel;
import android.os.Parcelable;
import com.kontakt.sdk.android.common.model.Model;
import com.kontakt.sdk.android.common.model.ResolvedId;
import com.kontakt.sdk.android.common.model.SecureProfileUid;
import com.kontakt.sdk.android.common.profile.IEddystoneDevice;
import com.kontakt.sdk.android.common.profile.ISecureProfile;
import com.kontakt.sdk.android.common.profile.RemoteBluetoothDevice;
import com.kontakt.sdk.android.common.util.SDKPreconditions;

public class SecureProfile
implements ISecureProfile {
    private String macAddress;
    private String name;
    private String uniqueId;
    private String firmwareRevision;
    private Model model;
    private int batteryLevel;
    private int txPower;
    private int rssi;
    private String namespace;
    private String instanceId;
    private boolean shuffled;
    public static final Parcelable.Creator<SecureProfile> CREATOR = new Parcelable.Creator<SecureProfile>(){

        public SecureProfile createFromParcel(Parcel source) {
            return new SecureProfile(source);
        }

        public SecureProfile[] newArray(int size) {
            return new SecureProfile[size];
        }
    };

    SecureProfile(Builder builder) {
        this.macAddress = builder.macAddress;
        this.name = builder.name;
        this.uniqueId = builder.uniqueId;
        this.firmwareRevision = builder.firmwareRevision;
        this.model = builder.model;
        this.batteryLevel = builder.batteryLevel;
        this.txPower = builder.txPower;
        this.namespace = builder.namespace;
        this.instanceId = builder.instanceId;
        this.shuffled = builder.shuffled;
        this.rssi = builder.rssi;
    }

    protected SecureProfile(Parcel in) {
        this.macAddress = in.readString();
        this.name = in.readString();
        this.uniqueId = in.readString();
        this.firmwareRevision = in.readString();
        int tmpModel = in.readInt();
        this.model = Model.fromCode(tmpModel);
        this.batteryLevel = in.readInt();
        this.txPower = in.readInt();
        this.rssi = in.readInt();
        this.namespace = in.readString();
        this.instanceId = in.readString();
        this.shuffled = in.readByte() != 0;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getMacAddress() {
        return this.macAddress;
    }

    @Override
    public String getUniqueId() {
        return this.uniqueId;
    }

    @Override
    public String getFirmwareRevision() {
        return this.firmwareRevision;
    }

    @Override
    public Model getModel() {
        return this.model;
    }

    @Override
    public int getBatteryLevel() {
        return this.batteryLevel;
    }

    @Override
    public int getTxPower() {
        return this.txPower;
    }

    @Override
    public String getNamespace() {
        return this.namespace;
    }

    @Override
    public String getInstanceId() {
        return this.instanceId;
    }

    @Override
    public boolean isShuffled() {
        return this.shuffled;
    }

    @Override
    public int getRssi() {
        return this.rssi;
    }

    public void setRssi(int rssi) {
        this.rssi = rssi;
    }

    public String toString() {
        return "SecureProfile{macAddress='" + this.macAddress + '\'' + ", name='" + this.name + '\'' + ", uniqueId='" + this.uniqueId + '\'' + ", firmwareRevision='" + this.firmwareRevision + '\'' + ", model='" + (Object)((Object)this.model) + '\'' + ", batteryLevel=" + this.batteryLevel + ", txPower=" + this.txPower + ", rssi=" + this.rssi + ", namespace='" + this.namespace + '\'' + ", instanceId='" + this.instanceId + '\'' + ", shuffled=" + this.shuffled + '}';
    }

    @Override
    public int compareTo(ISecureProfile iSecureProfile) {
        SDKPreconditions.checkNotNull(iSecureProfile, "Comparing to null device!");
        return Integer.valueOf(this.hashCode()).compareTo(iSecureProfile.hashCode());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SecureProfile that = (SecureProfile)o;
        if (this.batteryLevel != that.batteryLevel) {
            return false;
        }
        if (this.txPower != that.txPower) {
            return false;
        }
        if (this.rssi != that.rssi) {
            return false;
        }
        if (this.shuffled != that.shuffled) {
            return false;
        }
        if (this.macAddress != null ? !this.macAddress.equals(that.macAddress) : that.macAddress != null) {
            return false;
        }
        if (this.name != null ? !this.name.equals(that.name) : that.name != null) {
            return false;
        }
        if (this.uniqueId != null ? !this.uniqueId.equals(that.uniqueId) : that.uniqueId != null) {
            return false;
        }
        if (this.firmwareRevision != null ? !this.firmwareRevision.equals(that.firmwareRevision) : that.firmwareRevision != null) {
            return false;
        }
        if (this.model != that.model) {
            return false;
        }
        if (this.namespace != null ? !this.namespace.equals(that.namespace) : that.namespace != null) {
            return false;
        }
        return this.instanceId != null ? this.instanceId.equals(that.instanceId) : that.instanceId == null;
    }

    public int hashCode() {
        int result = this.macAddress != null ? this.macAddress.hashCode() : 0;
        result = 31 * result + (this.name != null ? this.name.hashCode() : 0);
        result = 31 * result + (this.uniqueId != null ? this.uniqueId.hashCode() : 0);
        result = 31 * result + (this.firmwareRevision != null ? this.firmwareRevision.hashCode() : 0);
        result = 31 * result + (this.model != null ? this.model.hashCode() : 0);
        result = 31 * result + this.batteryLevel;
        result = 31 * result + this.txPower;
        result = 31 * result + this.rssi;
        result = 31 * result + (this.namespace != null ? this.namespace.hashCode() : 0);
        result = 31 * result + (this.instanceId != null ? this.instanceId.hashCode() : 0);
        result = 31 * result + (this.shuffled ? 1 : 0);
        return result;
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        dest.writeString(this.macAddress);
        dest.writeString(this.name);
        dest.writeString(this.uniqueId);
        dest.writeString(this.firmwareRevision);
        dest.writeInt(this.model == null ? -1 : this.model.getCode());
        dest.writeInt(this.batteryLevel);
        dest.writeInt(this.txPower);
        dest.writeInt(this.rssi);
        dest.writeString(this.namespace);
        dest.writeString(this.instanceId);
        dest.writeByte(this.shuffled ? (byte)1 : 0);
    }

    public static class Builder {
        String macAddress;
        String name;
        String uniqueId;
        String firmwareRevision;
        Model model;
        int batteryLevel;
        int txPower;
        String namespace;
        String instanceId;
        boolean shuffled;
        int rssi;

        public Builder() {
        }

        public Builder(ISecureProfile secureDevice) {
            this.macAddress = secureDevice.getMacAddress();
            this.name = secureDevice.getName();
            this.uniqueId = secureDevice.getUniqueId();
            this.firmwareRevision = secureDevice.getFirmwareRevision();
            this.model = secureDevice.getModel();
            this.batteryLevel = secureDevice.getBatteryLevel();
            this.txPower = secureDevice.getTxPower();
            this.namespace = secureDevice.getNamespace();
            this.instanceId = secureDevice.getInstanceId();
            this.rssi = secureDevice.getRssi();
            this.shuffled = secureDevice.isShuffled();
        }

        public Builder(RemoteBluetoothDevice remoteBluetoothDevice) {
            this.macAddress = remoteBluetoothDevice.getAddress();
            this.name = remoteBluetoothDevice.getName();
            this.uniqueId = remoteBluetoothDevice.getUniqueId();
            this.firmwareRevision = remoteBluetoothDevice.getFirmwareVersion();
            this.model = Model.UNKNOWN;
            this.batteryLevel = remoteBluetoothDevice.getBatteryPower();
            this.txPower = remoteBluetoothDevice.getTxPower();
            this.rssi = remoteBluetoothDevice.getRssi();
            this.shuffled = remoteBluetoothDevice.isShuffled();
            if (remoteBluetoothDevice instanceof IEddystoneDevice) {
                this.namespace = ((IEddystoneDevice)remoteBluetoothDevice).getNamespace();
                this.instanceId = ((IEddystoneDevice)remoteBluetoothDevice).getInstanceId();
            }
        }

        public Builder macAddress(String macAddress) {
            this.macAddress = macAddress;
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder uniqueId(String uniqueId) {
            this.uniqueId = uniqueId;
            return this;
        }

        public Builder firmwareRevision(String firmwareRevision) {
            this.firmwareRevision = firmwareRevision;
            return this;
        }

        public Builder model(Model model) {
            this.model = model;
            return this;
        }

        public Builder batteryLevel(int batteryLevel) {
            this.batteryLevel = batteryLevel;
            return this;
        }

        public Builder txPower(int txPower) {
            this.txPower = txPower;
            return this;
        }

        public Builder namespace(String namespace) {
            this.namespace = namespace;
            return this;
        }

        public Builder instanceId(String instanceId) {
            this.instanceId = instanceId;
            return this;
        }

        public Builder shuffled(boolean isShuffled) {
            this.shuffled = isShuffled;
            return this;
        }

        public Builder rssi(int rssi) {
            this.rssi = rssi;
            return this;
        }

        public Builder resolvedId(ResolvedId resolvedId) {
            SecureProfileUid secureProfileUid = resolvedId.getSecureProfileUID();
            this.namespace = secureProfileUid.getNamespace();
            this.instanceId = secureProfileUid.getInstanceId();
            this.uniqueId = resolvedId.getUniqueId();
            return this;
        }

        public SecureProfile build() {
            return new SecureProfile(this);
        }
    }
}

