/*
 * Decompiled with CFR 0.152.
 */
package com.kontakt.sdk.android.ble.connection;

import android.annotation.TargetApi;
import android.bluetooth.BluetoothGattCharacteristic;
import android.bluetooth.BluetoothGattService;
import android.os.RemoteException;
import com.kontakt.sdk.android.ble.exception.CharacteristicAbsentException;
import com.kontakt.sdk.android.ble.exception.ServiceAbsentException;
import com.kontakt.sdk.android.ble.spec.BluetoothDeviceCharacteristic;
import com.kontakt.sdk.android.ble.spec.KontaktDeviceCharacteristic;
import com.kontakt.sdk.android.ble.spec.KontaktDeviceService;
import com.kontakt.sdk.android.common.util.SDKPreconditions;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;

public class KontaktDeviceServiceStore {
    private static final KontaktDeviceService REQUIRED_SERVICE_NORMAL_MODE = KontaktDeviceService.CONTROL;
    private static final KontaktDeviceService REQUIRED_SERVICE_SECURE_MODE = KontaktDeviceService.SECURE_CONFIGURATION_SERVICE;
    private final Map<KontaktDeviceService, Map<KontaktDeviceCharacteristic, BluetoothDeviceCharacteristic>> storeMap;
    private final StoreType storeType;

    @TargetApi(value=18)
    public KontaktDeviceServiceStore(List<BluetoothGattService> gattServices, StoreType storeType) throws RemoteException {
        SDKPreconditions.checkNotNullOrEmpty(gattServices, "Gatt Service list is null.");
        this.storeMap = new HashMap<KontaktDeviceService, Map<KontaktDeviceCharacteristic, BluetoothDeviceCharacteristic>>(gattServices.size());
        this.storeType = storeType;
        this.createStore(gattServices);
        try {
            this.assertRequiredServiceFound(storeType);
            this.assertRequiredServicesFoundIfDfuModeEnabled();
        }
        catch (ServiceAbsentException e) {
            throw new RemoteException("Beacon is not recognized as a Kontakt.io device");
        }
    }

    @TargetApi(value=18)
    private void createStore(List<BluetoothGattService> gattServices) {
        for (BluetoothGattService gattService : gattServices) {
            KontaktDeviceService service = KontaktDeviceService.valueOf(gattService.getUuid());
            if (service == null) continue;
            List gattCharacteristics = gattService.getCharacteristics();
            Map<KontaktDeviceCharacteristic, BluetoothDeviceCharacteristic> characteristics = this.storeMap.get((Object)service);
            if (characteristics == null) {
                characteristics = new HashMap<KontaktDeviceCharacteristic, BluetoothDeviceCharacteristic>(gattCharacteristics.size());
                this.storeMap.put(service, characteristics);
            }
            for (BluetoothGattCharacteristic gattCharacteristic : gattCharacteristics) {
                KontaktDeviceCharacteristic characteristic = KontaktDeviceCharacteristic.fromUuid(gattCharacteristic.getUuid());
                if (characteristic == null) continue;
                characteristics.put(characteristic, new BluetoothDeviceCharacteristic(gattCharacteristic));
            }
        }
    }

    public BluetoothDeviceCharacteristic getFirmwareRevisionCharacteristic() throws ServiceAbsentException, CharacteristicAbsentException {
        return this.getCharacteristic(this.getService(KontaktDeviceService.DEVICE_INFORMATION), KontaktDeviceCharacteristic.FIRMWARE_REVISION_STRING);
    }

    public BluetoothDeviceCharacteristic getDeviceTimeCharacteristic() throws ServiceAbsentException, CharacteristicAbsentException {
        return this.getCharacteristic(this.getService(KontaktDeviceService.CURRENT_TIME), KontaktDeviceCharacteristic.CURRENT_TIME);
    }

    public BluetoothDeviceCharacteristic getHardwareRevisionCharacteristic() throws ServiceAbsentException, CharacteristicAbsentException {
        return this.getCharacteristic(this.getService(KontaktDeviceService.DEVICE_INFORMATION), KontaktDeviceCharacteristic.HARDWARE_REVISION);
    }

    public BluetoothDeviceCharacteristic getManufacturerNameCharacteristic() throws ServiceAbsentException, CharacteristicAbsentException {
        return this.getCharacteristic(this.getService(KontaktDeviceService.DEVICE_INFORMATION), KontaktDeviceCharacteristic.MANUFACTURER_NAME);
    }

    public BluetoothDeviceCharacteristic getDeviceNameCharacteristic() throws ServiceAbsentException, CharacteristicAbsentException {
        return this.getCharacteristic(this.getService(KontaktDeviceService.GENERIC_ACCESS), KontaktDeviceCharacteristic.DEVICE_NAME);
    }

    public BluetoothDeviceCharacteristic getPropagatedDeviceNameCharacteristic() throws ServiceAbsentException, CharacteristicAbsentException {
        return this.getCharacteristic(this.getService(KontaktDeviceService.PROXIMITY), KontaktDeviceCharacteristic.PROPAGATED_DEVICE_NAME);
    }

    public BluetoothDeviceCharacteristic getMinorCharacteristic() throws ServiceAbsentException, CharacteristicAbsentException {
        return this.getCharacteristic(this.getService(KontaktDeviceService.PROXIMITY), KontaktDeviceCharacteristic.MINOR);
    }

    public BluetoothDeviceCharacteristic getNonConnectableCharacteristic() throws ServiceAbsentException, CharacteristicAbsentException {
        return this.getCharacteristic(this.getService(KontaktDeviceService.CONTROL), KontaktDeviceCharacteristic.NON_CONNECTABLE_MODE);
    }

    public BluetoothDeviceCharacteristic getShuffleIntervalCharacteristic() throws ServiceAbsentException, CharacteristicAbsentException {
        return this.getCharacteristic(this.getService(KontaktDeviceService.CONTROL), KontaktDeviceCharacteristic.SHUFFLE_INTERVAL);
    }

    public BluetoothDeviceCharacteristic getShuffleKeyCharacteristic() throws ServiceAbsentException, CharacteristicAbsentException {
        return this.getCharacteristic(this.getService(KontaktDeviceService.CONTROL), KontaktDeviceCharacteristic.SHUFFLE_KEY);
    }

    public BluetoothDeviceCharacteristic getSensorsCharacteristic() throws ServiceAbsentException, CharacteristicAbsentException {
        return this.getCharacteristic(this.getService(KontaktDeviceService.SENSORS_SERVICE), KontaktDeviceCharacteristic.SENSOR_ON);
    }

    public BluetoothDeviceCharacteristic getLightSensorCharacteristic() throws ServiceAbsentException, CharacteristicAbsentException {
        return this.getCharacteristic(this.getService(KontaktDeviceService.KONTAKT_SENSORS_SERVICE), KontaktDeviceCharacteristic.LIGHT_SENSOR_PERCENTAGE);
    }

    public BluetoothDeviceCharacteristic getAccelerometerCharacteristic() throws ServiceAbsentException, CharacteristicAbsentException {
        return this.getCharacteristic(this.getService(KontaktDeviceService.SENSORS_SERVICE), KontaktDeviceCharacteristic.ACCELEROMETER);
    }

    public BluetoothDeviceCharacteristic getActiveProfileCharacteristic() throws ServiceAbsentException, CharacteristicAbsentException {
        return this.getCharacteristic(this.getService(KontaktDeviceService.CONTROL), KontaktDeviceCharacteristic.ACTIVE_PROFILE);
    }

    public BluetoothDeviceCharacteristic getMajorCharacteristic() throws ServiceAbsentException, CharacteristicAbsentException {
        return this.getCharacteristic(this.getService(KontaktDeviceService.PROXIMITY), KontaktDeviceCharacteristic.MAJOR);
    }

    public BluetoothDeviceCharacteristic getProximityCharacteristic() throws ServiceAbsentException, CharacteristicAbsentException {
        return this.getCharacteristic(this.getService(KontaktDeviceService.PROXIMITY), KontaktDeviceCharacteristic.PROXIMITY_UUID);
    }

    public BluetoothDeviceCharacteristic getPowerLevelCharacteristic() throws ServiceAbsentException, CharacteristicAbsentException {
        return this.getCharacteristic(this.getService(KontaktDeviceService.TX_POWER), KontaktDeviceCharacteristic.TX_POWER_LEVEL);
    }

    public BluetoothDeviceCharacteristic getBatteryLevelCharacteristic() throws ServiceAbsentException, CharacteristicAbsentException {
        return this.getCharacteristic(this.getService(KontaktDeviceService.BATTERY_LEVEL), KontaktDeviceCharacteristic.BATTERY_LEVEL);
    }

    public BluetoothDeviceCharacteristic getPasswordCharacteristic() throws ServiceAbsentException, CharacteristicAbsentException {
        return this.getCharacteristic(this.getService(KontaktDeviceService.CONTROL), KontaktDeviceCharacteristic.PASSWORD);
    }

    public BluetoothDeviceCharacteristic getMasterPasswordCharacteristic() throws ServiceAbsentException, CharacteristicAbsentException {
        return this.getCharacteristic(this.getService(KontaktDeviceService.CONTROL), KontaktDeviceCharacteristic.MASTER_PASSWORD);
    }

    public BluetoothDeviceCharacteristic getSetNewPasswordCharacteristic() throws ServiceAbsentException, CharacteristicAbsentException {
        return this.getCharacteristic(this.getService(KontaktDeviceService.CONTROL), KontaktDeviceCharacteristic.SET_PASSWORD);
    }

    public BluetoothDeviceCharacteristic getAdvertisingIntervalCharacteristic() throws ServiceAbsentException, CharacteristicAbsentException {
        return this.getCharacteristic(this.getService(KontaktDeviceService.TIMERS), KontaktDeviceCharacteristic.ADVERTISING_INTERVAL);
    }

    public BluetoothDeviceCharacteristic getResetCharacteristic() throws ServiceAbsentException, CharacteristicAbsentException {
        return this.getCharacteristic(this.getService(KontaktDeviceService.CONTROL), KontaktDeviceCharacteristic.RESET);
    }

    public BluetoothDeviceCharacteristic getBootloaderCharacteristic() throws ServiceAbsentException, CharacteristicAbsentException {
        return this.getCharacteristic(this.getService(KontaktDeviceService.CONTROL), KontaktDeviceCharacteristic.BOOTLOADER);
    }

    public BluetoothDeviceCharacteristic getUniqueIdCharacteristic() throws ServiceAbsentException, CharacteristicAbsentException {
        return this.getCharacteristic(this.getService(KontaktDeviceService.PROXIMITY), KontaktDeviceCharacteristic.BEACON_ID);
    }

    public BluetoothDeviceCharacteristic getNamespaceIdCharacteristic() throws ServiceAbsentException, CharacteristicAbsentException {
        return this.getCharacteristic(this.getService(KontaktDeviceService.PROXIMITY), KontaktDeviceCharacteristic.NAMESPACE_ID);
    }

    public BluetoothDeviceCharacteristic getInstanceIdCharacteristic() throws ServiceAbsentException, CharacteristicAbsentException {
        return this.getCharacteristic(this.getService(KontaktDeviceService.PROXIMITY), KontaktDeviceCharacteristic.INSTANCE_ID);
    }

    public BluetoothDeviceCharacteristic getUrlCharacteristic() throws ServiceAbsentException, CharacteristicAbsentException {
        return this.getCharacteristic(this.getService(KontaktDeviceService.PROXIMITY), KontaktDeviceCharacteristic.URL_ID);
    }

    public BluetoothDeviceCharacteristic getDefaultSettingsCharacteristic() throws ServiceAbsentException, CharacteristicAbsentException {
        return this.getCharacteristic(this.getService(KontaktDeviceService.CONTROL), KontaktDeviceCharacteristic.DEFAULT_SETTINGS);
    }

    public BluetoothDeviceCharacteristic getSecureLastProcessedRequestTokenCharacteristic() throws ServiceAbsentException, CharacteristicAbsentException {
        return this.getCharacteristic(this.getService(KontaktDeviceService.SECURE_CONFIGURATION_SERVICE), KontaktDeviceCharacteristic.SECURE_LAST_PROCESSED_REQUEST_TOKEN);
    }

    @TargetApi(value=18)
    public BluetoothDeviceCharacteristic getSecureWriteCharacteristic() throws ServiceAbsentException, CharacteristicAbsentException {
        BluetoothDeviceCharacteristic characteristic = this.getCharacteristic(this.getService(KontaktDeviceService.SECURE_CONFIGURATION_SERVICE), KontaktDeviceCharacteristic.SECURE_WRITE);
        characteristic.setWriteType(2);
        return characteristic;
    }

    public BluetoothDeviceCharacteristic getSecureResponseCharacteristic() throws ServiceAbsentException, CharacteristicAbsentException {
        return this.getCharacteristic(this.getService(KontaktDeviceService.SECURE_CONFIGURATION_SERVICE), KontaktDeviceCharacteristic.SECURE_RESPONSE);
    }

    public BluetoothDeviceCharacteristic getSecureControlPointCharacteristic() throws ServiceAbsentException, CharacteristicAbsentException {
        return this.getCharacteristic(this.getService(KontaktDeviceService.SECURE_CONFIGURATION_SERVICE), KontaktDeviceCharacteristic.SECURE_CONTROL_POINT);
    }

    public BluetoothDeviceCharacteristic getDfuCommandCharacteristic() throws ServiceAbsentException, CharacteristicAbsentException {
        return this.getCharacteristic(this.getService(KontaktDeviceService.KONTAKT_DFU_SERVICE), KontaktDeviceCharacteristic.KDFU_COMMAND);
    }

    public BluetoothDeviceCharacteristic getDfuResponseCharacteristic() throws ServiceAbsentException, CharacteristicAbsentException {
        return this.getCharacteristic(this.getService(KontaktDeviceService.KONTAKT_DFU_SERVICE), KontaktDeviceCharacteristic.KDFU_RESPONSE);
    }

    public BluetoothDeviceCharacteristic getDfuDataCharacteristic() throws ServiceAbsentException, CharacteristicAbsentException {
        return this.getCharacteristic(this.getService(KontaktDeviceService.KONTAKT_DFU_SERVICE), KontaktDeviceCharacteristic.KDFU_DATA);
    }

    public BluetoothDeviceCharacteristic getGatewayNetworkCountCharacteristic() throws ServiceAbsentException, CharacteristicAbsentException {
        return this.getCharacteristic(this.getService(KontaktDeviceService.GATEWAY_WIFI_NETWORKS_SERVICE), KontaktDeviceCharacteristic.GATEWAY_NETWORKS_LENGTH);
    }

    public BluetoothDeviceCharacteristic getGatewayNetworkIndexCharacteristic() throws ServiceAbsentException, CharacteristicAbsentException {
        return this.getCharacteristic(this.getService(KontaktDeviceService.GATEWAY_WIFI_NETWORKS_SERVICE), KontaktDeviceCharacteristic.GATEWAY_NETWORKS_INDEX);
    }

    public BluetoothDeviceCharacteristic getGatewayNetworkRecordCharacteristic() throws ServiceAbsentException, CharacteristicAbsentException {
        return this.getCharacteristic(this.getService(KontaktDeviceService.GATEWAY_WIFI_NETWORKS_SERVICE), KontaktDeviceCharacteristic.GATEWAY_NETWORKS_RECORD);
    }

    public StoreType getStoreType() {
        return this.storeType;
    }

    public boolean contains(KontaktDeviceService service) {
        return this.storeMap.containsKey((Object)service);
    }

    @TargetApi(value=18)
    public void replace(BluetoothDeviceCharacteristic characteristicWrapper) throws ServiceAbsentException {
        UUID serviceUuid = characteristicWrapper.getService().getUuid();
        UUID characteristicUuid = characteristicWrapper.getId();
        KontaktDeviceService serviceModel = KontaktDeviceService.valueOf(serviceUuid);
        KontaktDeviceCharacteristic characteristicModel = KontaktDeviceCharacteristic.fromUuid(characteristicUuid);
        this.storeMap.get((Object)serviceModel).put(characteristicModel, characteristicWrapper);
    }

    public void clear() {
        this.storeMap.clear();
    }

    public final Collection<BluetoothDeviceCharacteristic> getReadableCharacteristics() {
        ArrayList<BluetoothDeviceCharacteristic> readableCharacteristics = new ArrayList<BluetoothDeviceCharacteristic>();
        for (Map<KontaktDeviceCharacteristic, BluetoothDeviceCharacteristic> characteristicMap : this.storeMap.values()) {
            for (BluetoothDeviceCharacteristic characteristic : characteristicMap.values()) {
                if (!characteristic.isReadable()) continue;
                readableCharacteristics.add(characteristic);
            }
        }
        return Collections.unmodifiableCollection(readableCharacteristics);
    }

    Map<KontaktDeviceCharacteristic, BluetoothDeviceCharacteristic> getService(KontaktDeviceService service) throws ServiceAbsentException {
        SDKPreconditions.checkNotNull(service, "Service is null.");
        SDKPreconditions.checkArgument(this.contains(service), new ServiceAbsentException(String.format("The Service %s was not found during services discovery", new Object[]{service})));
        return Collections.unmodifiableMap(this.storeMap.get((Object)service));
    }

    BluetoothDeviceCharacteristic getCharacteristic(Map<KontaktDeviceCharacteristic, BluetoothDeviceCharacteristic> map, KontaktDeviceCharacteristic characteristic) throws CharacteristicAbsentException {
        SDKPreconditions.checkState(map.containsKey((Object)characteristic), new CharacteristicAbsentException(String.format("The characteristic %s is absent", characteristic == null ? "" : characteristic)));
        return map.get((Object)characteristic);
    }

    private void assertRequiredServiceFound(StoreType storeType) throws ServiceAbsentException {
        switch (storeType) {
            case NORMAL: {
                this.getService(REQUIRED_SERVICE_NORMAL_MODE);
                break;
            }
            case SECURE: {
                this.getService(REQUIRED_SERVICE_SECURE_MODE);
            }
        }
    }

    private void assertRequiredServicesFoundIfDfuModeEnabled() throws ServiceAbsentException {
        if (this.contains(KontaktDeviceService.DFU_SERVICE)) {
            EnumSet<KontaktDeviceService> requiredServices = EnumSet.of(KontaktDeviceService.GENERIC_ACCESS, KontaktDeviceService.GENERIC_ATTRIBUTE, KontaktDeviceService.DFU_SERVICE);
            for (KontaktDeviceService kontaktDeviceService : requiredServices) {
                this.getService(kontaktDeviceService);
            }
        }
    }

    public static enum StoreType {
        NORMAL,
        SECURE;

    }
}

