/*
 * Decompiled with CFR 0.152.
 */
package com.kontakt.sdk.android.ble.cache;

import com.kontakt.sdk.android.ble.cache.ResolveRequestStatus;
import com.kontakt.sdk.android.ble.cache.ResolverType;
import com.kontakt.sdk.android.ble.cache.SecureProfileResolveRequest;
import com.kontakt.sdk.android.ble.cache.SecureProfileResolveStrategy;
import com.kontakt.sdk.android.cloud.KontaktCloud;
import com.kontakt.sdk.android.cloud.exception.KontaktCloudException;
import com.kontakt.sdk.android.cloud.response.paginated.Devices;
import com.kontakt.sdk.android.common.model.Device;
import com.kontakt.sdk.android.common.model.SecureProfileFutureUID;
import com.kontakt.sdk.android.common.model.SecureProfileUid;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

class SecureProfileApiResolveStrategy
implements SecureProfileResolveStrategy {
    private final KontaktCloud kontaktCloud;

    SecureProfileApiResolveStrategy(KontaktCloud kontaktCloud) {
        this.kontaktCloud = kontaktCloud;
    }

    @Override
    public List<SecureProfileFutureUID> resolve(Map<SecureProfileUid, SecureProfileResolveRequest> requests) throws Exception {
        List<SecureProfileUid> toResolve = this.secureProfilesToResolve(requests);
        if (toResolve.isEmpty()) {
            return Collections.emptyList();
        }
        List<SecureProfileFutureUID> futureIds = this.resolveSecureProfiles(toResolve);
        this.updateRequests(requests, futureIds);
        return futureIds;
    }

    private List<SecureProfileUid> secureProfilesToResolve(Map<SecureProfileUid, SecureProfileResolveRequest> requests) {
        ArrayList<SecureProfileUid> toResolve = new ArrayList<SecureProfileUid>();
        for (Map.Entry<SecureProfileUid, SecureProfileResolveRequest> entry : requests.entrySet()) {
            SecureProfileResolveRequest request = entry.getValue();
            if (ResolveRequestStatus.RESOLVED == request.getStatus()) continue;
            toResolve.add(entry.getKey());
        }
        return toResolve;
    }

    private List<SecureProfileFutureUID> resolveSecureProfiles(List<SecureProfileUid> uids) throws IOException, KontaktCloudException {
        Devices cloudResult = (Devices)this.kontaktCloud.devices().eddystones().withSecureProfileIds(uids).execute();
        Object devices = cloudResult.getContent();
        ArrayList<SecureProfileFutureUID> futureIds = new ArrayList<SecureProfileFutureUID>();
        Iterator iterator = devices.iterator();
        while (iterator.hasNext()) {
            Device device = (Device)iterator.next();
            SecureProfileFutureUID secureProfileFutureUID = device.extractSecureProfileFutureUID();
            if (secureProfileFutureUID == null) continue;
            futureIds.add(secureProfileFutureUID);
        }
        return futureIds;
    }

    private void updateRequests(Map<SecureProfileUid, SecureProfileResolveRequest> requests, List<SecureProfileFutureUID> futureIds) {
        for (SecureProfileFutureUID id : futureIds) {
            this.updateRequest(requests, id);
        }
    }

    private void updateRequest(Map<SecureProfileUid, SecureProfileResolveRequest> requests, SecureProfileFutureUID id) {
        SecureProfileResolveRequest request = requests.get(id.getQueriedBy());
        request.setResolvedBy(ResolverType.API);
        if (ResolveRequestStatus.IGNORED == request.getStatus()) {
            return;
        }
        request.setStatus(ResolveRequestStatus.RESOLVED);
    }
}

