package com.kontakt.sdk.android.common.model;

/**
 * Enumeration of interleave packet type.
 */
public enum PacketType {

  /**
   * iBeacon packet.
   */
  IBEACON("IBEACON"),

  /**
   * Eddystone UID packet.
   */
  EDDYSTONE_UID("UID"),

  /**
   * Eddystone URL packet.
   */
  EDDYSTONE_URL("URL"),

  /**
   * Eddystone TLM packet.
   */
  EDDYSTONE_TLM("TLM"),

  /**
   * Eddystone EID packet.
   */
  EDDYSTONE_EID("EID"),

  /**
   * Eddystone encrypted telemetry packet.
   */
  EDDYSTONE_ETLM("ETLM"),

  /**
   * Kontakt Secure Profile connectable packet
   */
  KONTAKT("KONTAKT_PROFILE");

  private final String shortName;

  PacketType(String shortName) {
    this.shortName = shortName;
  }

  public String getShortName() {
    return shortName;
  }

  public static PacketType fromShortName(String value) {
    for (PacketType packetType : PacketType.values()) {
      if (packetType.getShortName().equals(value)) {
        return packetType;
      }
    }
    throw new IllegalArgumentException("Can't create PacketType from given string");
  }
}
