package com.kontakt.sdk.android.ble.security.property;

import static com.kontakt.sdk.android.ble.security.property.PropertyDataType.BYTE_ARRAY;
import static com.kontakt.sdk.android.ble.security.property.PropertyDataType.INT8;
import static com.kontakt.sdk.android.ble.security.property.PropertyDataType.NONE;
import static com.kontakt.sdk.android.ble.security.property.PropertyDataType.STRING;
import static com.kontakt.sdk.android.ble.security.property.PropertyDataType.UINT16;
import static com.kontakt.sdk.android.ble.security.property.PropertyDataType.UINT32;
import static com.kontakt.sdk.android.ble.security.property.PropertyDataType.UINT8;

public enum PropertyID {
  PROXIMITY_UUID(0x8111, BYTE_ARRAY),
  MAJOR(0x8112, UINT16),
  MINOR(0x8113, UINT16),
  NAME(0x8114, STRING),
  BEACON_ID(0x8115, STRING),
  REF_TX_1M(0x8116, BYTE_ARRAY),
  NAMESPACE_ID(0x8117, BYTE_ARRAY),
  INSTANCE_ID(0x8118, BYTE_ARRAY),
  URL(0x8119, BYTE_ARRAY),
  REF_TX_0M(0x811A, BYTE_ARRAY),
  INTERVAL(0x8121, UINT16),
  SET_PASSWORD(0x8132, STRING),
  SHUFFLE_INTERVAL(0x8138, UINT16),
  ACTIVE_PROFILE(0x813A, UINT8),
  TX_POWER(0x2A07, INT8),
  EDDY_EID_SCALER(0x811c, UINT8),
  BEACON_PACKETS_MASK(0x811e, UINT32),
  POWER_SAVER_FEATURES_MASK(0x8300, UINT32),
  MOVE_SUSPEND_TIMEOUT(0x8301, UINT32),
  LIGHT_SENSOR_THRESHOLD(0x8302, INT8),
  LIGHT_SENSOR_HIST(0x8303, INT8),
  LIGHT_SENSOR_SAMPLING_INTERVAL(0x8304, UINT32),
  WIFI_SSID(0x8201, STRING),
  WIFI_USER(0x8202, STRING),
  WIFI_PASS(0x8203, STRING),
  WIFI_PROTOCOL(0x8204, INT8),
  API_KEY(0x8205, STRING),
  TERMINATING(0xFFFF, NONE);

  private final short value;
  private final PropertyDataType type;

  PropertyID(int value, PropertyDataType type) {
    this.type = type;
    this.value = (short) value;
  }

  public short getValue() {
    return value;
  }

  public PropertyDataType getDataType() {
    return type;
  }

  public static PropertyID of(short value) {
    PropertyID[] arr = values();
    int len = arr.length;

    for (int i = 0; i < len; i++) {
      if (arr[i].getValue() == value) {
        return arr[i];
      }
    }
    return null;
  }

}
