package com.kontakt.sdk.android.ble.connection;

import com.kontakt.sdk.android.cloud.KontaktCloud;
import com.kontakt.sdk.android.cloud.response.CloudCallback;
import com.kontakt.sdk.android.cloud.response.CloudError;
import com.kontakt.sdk.android.cloud.response.CloudHeaders;
import com.kontakt.sdk.android.common.model.Config;
import com.kontakt.sdk.android.common.model.Device;

class InternalBeaconWriteBatchListener<T> implements WriteBatchListener<T> {

  SyncableKontaktDeviceConnectionImpl.SyncWriteBatchListener<T> syncWriteBatchListener;
  private KontaktCloud kontaktCloud;

  public InternalBeaconWriteBatchListener(KontaktCloud kontaktCloud,
      SyncableKontaktDeviceConnectionImpl.SyncWriteBatchListener<T> syncWriteBatchListener) {
    this.kontaktCloud = kontaktCloud;
    this.syncWriteBatchListener = syncWriteBatchListener;
  }

  @Override
  public void onWriteBatchStart(T batchHolder) {
    if (syncWriteBatchListener != null) {
      syncWriteBatchListener.onSyncWriteBatchStart(batchHolder);
    }
  }

  @Override
  public void onWriteBatchFinish(T batchHolder) {
    if (batchHolder instanceof Config) {
      applyConfig((Config) batchHolder, batchHolder);
    }
  }

  @Override
  public void onErrorOccured(int errorCode) {
    if (syncWriteBatchListener != null) {
      syncWriteBatchListener.onBatchWriteError(errorCode);
    }
  }

  @Override
  public void onWriteFailure() {
    if (syncWriteBatchListener != null) {
      syncWriteBatchListener.onWriteFailed();
    }
  }

  private void applyConfig(final Config config, final T batchHolder) {
    final Device updatedData = new Device.Builder().config(config).build();
    kontaktCloud.devices().update(config.getUniqueId()).with(updatedData).execute(new CloudCallback<String>() {
      @Override
      public void onSuccess(String response, CloudHeaders headers) {
        syncWriteBatchListener.onSuccess(batchHolder);
      }

      @Override
      public void onError(CloudError error) {
        syncWriteBatchListener.onSyncFailed(error.getMessage(), error.getStatus());
      }
    });
  }
}
