/*
 * Decompiled with CFR 0.152.
 */
package com.kontakt.sdk.android.common.util;

import android.text.TextUtils;
import com.kontakt.sdk.android.common.FirmwareRevisions;
import com.kontakt.sdk.android.common.util.ConversionUtils;
import com.kontakt.sdk.android.common.util.EddystoneUtils;
import com.kontakt.sdk.android.common.util.SDKPreconditions;

public final class IBeaconPropertyValidator {
    private static final int MAX_MAJOR = Double.valueOf(Math.pow(2.0, 16.0)).intValue();
    private static final int MAX_MINOR = Double.valueOf(Math.pow(2.0, 16.0)).intValue();
    private static final int PASSWORD_LENGTH = 4;
    private static final int PASSWORD_MAX_LENGTH = 16;
    private static final int MASTER_PASSWORD_MAX_LENGTH = 6;
    private static final int MODEL_NAME_MAX_LENGTH = 16;

    private IBeaconPropertyValidator() {
    }

    public static void validateModelName(String name) {
        SDKPreconditions.checkArgument(!TextUtils.isEmpty((CharSequence)name), "Model name is null or empty");
        SDKPreconditions.checkArgument(name.length() < 16, "Device name length must not be higher than 15 ASCII symbols.");
        EddystoneUtils.isAllASCIIPrintable(name);
    }

    public static void validateMajor(int major) {
        SDKPreconditions.checkArgument(major >= 0 && major < MAX_MAJOR, "Allowed range of major value: [1...65535]");
    }

    public static void validateMinor(int minor) {
        SDKPreconditions.checkArgument(minor >= 0 && minor < MAX_MINOR, "Allowed range of minor value: [1...65535]");
    }

    public static void validatePowerLevel(int txPowerLevel) {
        ConversionUtils.convertPowerLevel(txPowerLevel);
    }

    public static void validateAdvertisingInterval(int beaconIntervalMillis) {
        SDKPreconditions.checkArgument(beaconIntervalMillis >= 20 && beaconIntervalMillis <= 10240, "Advertising interval must be within range: [20...10240] ms.");
    }

    public static void validateBeaconPassword(String beaconPassword, String firmwareRevision) {
        SDKPreconditions.checkNotNullOrEmpty(beaconPassword, "New Password is null or empty.");
        if (FirmwareRevisions.NORMAL_MODE_FIRMWARE_VERSIONS.contains(firmwareRevision)) {
            SDKPreconditions.checkArgument(beaconPassword.length() == 4, "Beacon password must consist of 4 ASCII symbols");
        } else if (FirmwareRevisions.SECURE_MODE_FIRMWARE_VERSIONS.contains(firmwareRevision)) {
            SDKPreconditions.checkArgument(beaconPassword.length() >= 4 && beaconPassword.length() <= 16, "Beacon password must consist of 4 to 16 ASCII symbols");
        }
    }

    public static void validateBeaconMasterPassword(String masterPassword) {
        SDKPreconditions.checkArgument(masterPassword.length() == 6, "Beacon master password must consist of 6 ASCII symbols");
    }
}

