/*
 * Decompiled with CFR 0.152.
 */
package com.kontakt.sdk.android.common.model;

import android.os.Parcel;
import android.os.Parcelable;
import com.kontakt.sdk.android.common.util.SDKPreconditions;
import java.util.Arrays;
import java.util.EnumSet;

public class Network
implements Parcelable {
    private static final int BLE_NETWORK_MIN_LENGTH = 6;
    private static final int SSID_INDEX = 6;
    private static final int ENTERPRISE_FLAG = 2;
    private final int signalStrength;
    private final boolean isSecure;
    private final String name;
    private final String login;
    private final String password;
    private final String apiKey;
    private final EnumSet<Type> type;
    public static final Parcelable.Creator<Network> CREATOR = new Parcelable.Creator<Network>(){

        public Network createFromParcel(Parcel source) {
            return new Network(source);
        }

        public Network[] newArray(int size) {
            return new Network[size];
        }
    };

    public static Network fromBleValue(byte[] value) {
        SDKPreconditions.checkArgument(value.length > 6, "Unexpected frame length. Should be at least: 6");
        byte wpaFlag = value[3];
        byte rsnFlag = value[5];
        boolean isSecure = value[1] == 1;
        EnumSet<Type> type = EnumSet.noneOf(Type.class);
        if (isSecure) {
            if (wpaFlag == 0 && rsnFlag == 0) {
                type.add(Type.WEP);
            }
            if (wpaFlag != 0) {
                type.add(wpaFlag == 2 ? Type.WPA_ENTERPRISE : Type.WPA_PERSONAL);
            }
            if (rsnFlag != 0) {
                type.add(rsnFlag == 2 ? Type.WPA2_ENTERPRISE : Type.WPA2_PERSONAL);
            }
        } else {
            type.add(Type.NONE);
        }
        return new Builder().signalStrength(value[0]).isSecure(isSecure).type(type).name(new String(Arrays.copyOfRange(value, 6, value.length))).build();
    }

    public Network(Builder builder) {
        this.signalStrength = builder.signalStrength;
        this.isSecure = builder.isSecure;
        this.name = builder.name;
        this.login = builder.login;
        this.password = builder.password;
        this.type = builder.type;
        this.apiKey = builder.apiKey;
    }

    private Network() {
        this(new Builder());
    }

    public int getSignalStrength() {
        return this.signalStrength;
    }

    public boolean isSecure() {
        return this.isSecure;
    }

    public boolean isEnterprise() {
        return this.type != null && (this.type.contains((Object)Type.WPA2_ENTERPRISE) || this.type.contains((Object)Type.WPA_ENTERPRISE));
    }

    public boolean isPersonal() {
        return this.type != null && (this.type.contains((Object)Type.WPA2_PERSONAL) || this.type.contains((Object)Type.WPA_PERSONAL));
    }

    public String getName() {
        return this.name;
    }

    public String getLogin() {
        return this.login;
    }

    public String getPassword() {
        return this.password;
    }

    public String getApiKey() {
        return this.apiKey;
    }

    public EnumSet<Type> getType() {
        return this.type;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Network network = (Network)o;
        if (this.signalStrength != network.signalStrength) {
            return false;
        }
        if (this.isSecure != network.isSecure) {
            return false;
        }
        if (this.name != null ? !this.name.equals(network.name) : network.name != null) {
            return false;
        }
        if (this.login != null ? !this.login.equals(network.login) : network.login != null) {
            return false;
        }
        if (this.password != null ? !this.password.equals(network.password) : network.password != null) {
            return false;
        }
        if (this.apiKey != null ? !this.apiKey.equals(network.apiKey) : network.apiKey != null) {
            return false;
        }
        return this.type != null ? this.type.equals(network.type) : network.type == null;
    }

    public int hashCode() {
        int result = this.signalStrength;
        result = 31 * result + (this.isSecure ? 1 : 0);
        result = 31 * result + (this.name != null ? this.name.hashCode() : 0);
        result = 31 * result + (this.login != null ? this.login.hashCode() : 0);
        result = 31 * result + (this.password != null ? this.password.hashCode() : 0);
        result = 31 * result + (this.apiKey != null ? this.apiKey.hashCode() : 0);
        result = 31 * result + (this.type != null ? this.type.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "Network{signalStrength=" + this.signalStrength + ", isSecure=" + this.isSecure + ", name='" + this.name + '\'' + ", login='" + this.login + '\'' + ", password='" + this.password + '\'' + ", apiKey='" + this.apiKey + '\'' + ", type=" + Arrays.toString(this.type.toArray()) + '}';
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        dest.writeInt(this.signalStrength);
        dest.writeByte(this.isSecure ? (byte)1 : 0);
        dest.writeString(this.name);
        dest.writeString(this.login);
        dest.writeString(this.password);
        dest.writeString(this.apiKey);
        dest.writeSerializable(this.type);
    }

    protected Network(Parcel in) {
        this.signalStrength = in.readInt();
        this.isSecure = in.readByte() != 0;
        this.name = in.readString();
        this.login = in.readString();
        this.password = in.readString();
        this.apiKey = in.readString();
        this.type = (EnumSet)in.readSerializable();
    }

    public static enum Type {
        WEP,
        WPA_PERSONAL,
        WPA_ENTERPRISE,
        WPA2_PERSONAL,
        WPA2_ENTERPRISE,
        NONE;

    }

    public static class Builder {
        int signalStrength;
        boolean isSecure;
        String name;
        String password;
        String apiKey;
        String login;
        EnumSet<Type> type;

        public Builder signalStrength(int signalStrength) {
            this.signalStrength = signalStrength;
            return this;
        }

        public Builder isSecure(boolean secure) {
            this.isSecure = secure;
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder login(String login) {
            this.login = login;
            return this;
        }

        public Builder password(String password) {
            this.password = password;
            return this;
        }

        public Builder apiKey(String apiKey) {
            this.apiKey = apiKey;
            return this;
        }

        public Builder type(EnumSet<Type> type) {
            this.type = type;
            return this;
        }

        public Network build() {
            return new Network(this);
        }
    }
}

