/*
 * Decompiled with CFR 0.152.
 */
package com.kontakt.sdk.android.common.model;

import android.os.Parcel;
import android.os.Parcelable;
import com.kontakt.sdk.android.common.profile.IBeaconDevice;
import com.kontakt.sdk.android.common.util.HashCodeBuilder;
import com.kontakt.sdk.android.common.util.SDKEqualsBuilder;
import com.kontakt.sdk.android.common.util.SDKPreconditions;
import java.io.Serializable;
import java.util.UUID;

public class IBeaconId
implements Parcelable {
    public static final Parcelable.Creator<IBeaconId> CREATOR = new Parcelable.Creator<IBeaconId>(){

        public IBeaconId createFromParcel(Parcel source) {
            return new IBeaconId(source);
        }

        public IBeaconId[] newArray(int size) {
            return new IBeaconId[size];
        }
    };
    private UUID proximity;
    private int major;
    private int minor;

    public static IBeaconId of(UUID proximity, int major, int minor) {
        return new IBeaconId(proximity, major, minor);
    }

    public static IBeaconId fromDevice(IBeaconDevice iBeaconDevice) {
        UUID proximity = iBeaconDevice.getProximityUUID();
        int major = iBeaconDevice.getMajor();
        int minor = iBeaconDevice.getMinor();
        return new IBeaconId(proximity, major, minor);
    }

    public static IBeaconId fromQueriedBy(String queriedBy) {
        SDKPreconditions.checkNotNull(queriedBy, "queriedBy is null");
        String[] split = queriedBy.split(":");
        if (split.length != 3) {
            throw new IllegalArgumentException("queriedBy is not valid format");
        }
        UUID proximity = UUID.fromString(split[0]);
        int major = Integer.parseInt(split[1]);
        int minor = Integer.parseInt(split[2]);
        return new IBeaconId(proximity, major, minor);
    }

    private IBeaconId(UUID proximity, int major, int minor) {
        this.proximity = proximity;
        this.major = major;
        this.minor = minor;
    }

    protected IBeaconId(Parcel in) {
        this.proximity = (UUID)in.readSerializable();
        this.major = in.readInt();
        this.minor = in.readInt();
    }

    public UUID getProximity() {
        return this.proximity;
    }

    public int getMajor() {
        return this.major;
    }

    public int getMinor() {
        return this.minor;
    }

    public String toString() {
        return this.proximity.toString() + ":" + this.major + ":" + this.minor;
    }

    public boolean equals(Object o) {
        if (o == null || !(o instanceof IBeaconId)) {
            return false;
        }
        if (o == this) {
            return true;
        }
        IBeaconId beaconId = (IBeaconId)o;
        return SDKEqualsBuilder.start().equals(this.proximity, beaconId.proximity).equals(this.major, beaconId.major).equals(this.minor, beaconId.minor).result();
    }

    public int hashCode() {
        return HashCodeBuilder.init().append(this.proximity).append(this.major).append(this.minor).build();
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        dest.writeSerializable((Serializable)this.proximity);
        dest.writeInt(this.major);
        dest.writeInt(this.minor);
    }
}

