/*
 * Decompiled with CFR 0.152.
 */
package com.kontakt.sdk.android.cloud.api.executor.devices;

import com.kontakt.sdk.android.cloud.api.executor.RequestExecutor;
import com.kontakt.sdk.android.cloud.api.service.DevicesService;
import com.kontakt.sdk.android.cloud.exception.KontaktCloudException;
import com.kontakt.sdk.android.cloud.response.CloudCallback;
import com.kontakt.sdk.android.cloud.util.StringUtils;
import com.kontakt.sdk.android.common.util.SDKPreconditions;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import retrofit2.Call;

public class UnshareDeviceRequestExecutor
extends RequestExecutor<String> {
    private final DevicesService devicesService;
    private final String[] uniqueIds;
    private String[] managerEmails;

    public UnshareDeviceRequestExecutor(DevicesService devicesService, String ... uniqueIds) {
        this.devicesService = devicesService;
        this.uniqueIds = uniqueIds;
    }

    public UnshareDeviceRequestExecutor(DevicesService devicesService, List<String> uniqueIds) {
        this.devicesService = devicesService;
        int size = uniqueIds.size();
        this.uniqueIds = uniqueIds.toArray(new String[size]);
    }

    public UnshareDeviceRequestExecutor fromManagers(String ... managerEmails) {
        SDKPreconditions.checkNotNull(managerEmails, "manager emails cannot be null");
        this.managerEmails = managerEmails;
        return this;
    }

    public UnshareDeviceRequestExecutor fromManagers(List<String> managerEmails) {
        SDKPreconditions.checkNotNull(managerEmails, "manager emails cannot be null");
        int size = managerEmails.size();
        this.managerEmails = managerEmails.toArray(new String[size]);
        return this;
    }

    @Override
    public String execute() throws IOException, KontaktCloudException {
        this.checkPreconditions();
        return (String)super.execute();
    }

    @Override
    public void execute(CloudCallback<String> callback) {
        this.checkPreconditions();
        super.execute(callback);
    }

    @Override
    protected Call<String> prepareCall() {
        return this.devicesService.unshareDevices(this.params());
    }

    private void checkPreconditions() {
        SDKPreconditions.checkState(this.managerEmails != null, "cannot share device - specify managers");
    }

    @Override
    protected Map<String, String> params() {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("uniqueId", StringUtils.join(this.uniqueIds, ","));
        params.put("managerMail", StringUtils.join(this.managerEmails, ","));
        return params;
    }
}

