/*
 * Decompiled with CFR 0.152.
 */
package com.kontakt.sdk.android.cloud.api.executor.devices;

import com.kontakt.sdk.android.cloud.api.executor.RequestExecutor;
import com.kontakt.sdk.android.cloud.api.service.DevicesService;
import com.kontakt.sdk.android.cloud.exception.KontaktCloudException;
import com.kontakt.sdk.android.cloud.response.CloudCallback;
import com.kontakt.sdk.android.cloud.util.StringUtils;
import com.kontakt.sdk.android.common.model.Access;
import com.kontakt.sdk.android.common.util.SDKPreconditions;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import retrofit2.Call;

public class ShareDeviceRequestExecutor
extends RequestExecutor<String> {
    private final DevicesService devicesService;
    private final String[] uniqueIds;
    private String[] managerEmails;
    private Access access;
    private long expirationDate = -1L;
    private boolean withMetaData;

    public ShareDeviceRequestExecutor(DevicesService devicesService, String ... uniqueIds) {
        this.devicesService = devicesService;
        this.uniqueIds = uniqueIds;
    }

    public ShareDeviceRequestExecutor(DevicesService devicesService, List<String> uniqueIds) {
        this.devicesService = devicesService;
        int size = uniqueIds.size();
        this.uniqueIds = uniqueIds.toArray(new String[size]);
    }

    public ShareDeviceRequestExecutor toManagers(String ... managerEmails) {
        SDKPreconditions.checkNotNull(managerEmails, "manager emails cannot be null");
        this.managerEmails = managerEmails;
        return this;
    }

    public ShareDeviceRequestExecutor toManagers(List<String> managerEmails) {
        SDKPreconditions.checkNotNull(managerEmails, "manager emails cannot be null");
        int size = managerEmails.size();
        this.managerEmails = managerEmails.toArray(new String[size]);
        return this;
    }

    public ShareDeviceRequestExecutor withAccess(Access access) {
        SDKPreconditions.checkNotNull(access, "access cannot be null");
        SDKPreconditions.checkState(access == Access.VIEWER || access == Access.EDITOR, "cannot share beacon with " + access.name() + " access. Should be VIEWER or EDITOR");
        this.access = access;
        return this;
    }

    public ShareDeviceRequestExecutor expirationDate(long expirationDate) {
        SDKPreconditions.checkState(expirationDate > 0L, "expiration date cannot be negative");
        this.expirationDate = expirationDate;
        return this;
    }

    public ShareDeviceRequestExecutor withMetaData(boolean withMetaData) {
        this.withMetaData = withMetaData;
        return this;
    }

    @Override
    public String execute() throws IOException, KontaktCloudException {
        this.checkPreconditions();
        return (String)super.execute();
    }

    @Override
    public void execute(CloudCallback<String> callback) {
        this.checkPreconditions();
        super.execute(callback);
    }

    @Override
    protected Call<String> prepareCall() {
        return this.devicesService.shareDevices(this.params());
    }

    private void checkPreconditions() {
        SDKPreconditions.checkState(this.managerEmails != null, "cannot share device - specify managers");
        SDKPreconditions.checkState(this.access != null, "cannot share device - specify access");
    }

    @Override
    protected Map<String, String> params() {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("uniqueId", StringUtils.join(this.uniqueIds, ","));
        params.put("managerMail", StringUtils.join(this.managerEmails, ","));
        params.put("access", this.access.name());
        params.put("withMetaData", String.valueOf(this.withMetaData));
        if (this.expirationDate >= 0L) {
            params.put("expirationDate", String.valueOf(this.expirationDate));
        }
        return params;
    }
}

