/*
 * Decompiled with CFR 0.152.
 */
package com.kontakt.sdk.android.cloud.api.executor.actions;

import android.util.Base64;
import com.kontakt.sdk.android.cloud.api.executor.actions.CreateActionRequestExecutor;
import com.kontakt.sdk.android.cloud.api.service.ActionsService;
import com.kontakt.sdk.android.cloud.util.StringUtils;
import com.kontakt.sdk.android.common.Proximity;
import com.kontakt.sdk.android.common.model.Action;
import com.kontakt.sdk.android.common.util.ConversionUtils;
import com.kontakt.sdk.android.common.util.SDKPreconditions;
import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import okhttp3.MediaType;
import okhttp3.MultipartBody;
import okhttp3.RequestBody;
import retrofit2.Call;

public class CreateContentActionRequestExecutor
extends CreateActionRequestExecutor {
    private File file;
    private String encodedFile;
    private boolean isMultipart;

    public CreateContentActionRequestExecutor(ActionsService actionsService) {
        super(actionsService);
        this.actionType = Action.Type.CONTENT;
    }

    public CreateContentActionRequestExecutor withMediaFile(File file) throws IOException {
        SDKPreconditions.checkNotNull(file, "file is null");
        SDKPreconditions.checkState(file.exists(), "file does not exist");
        byte[] bytes = ConversionUtils.convert(file);
        this.file = file;
        this.encodedFile = Base64.encodeToString((byte[])bytes, (int)0);
        return this;
    }

    public CreateContentActionRequestExecutor multipart(boolean isMultipart) {
        this.isMultipart = isMultipart;
        return this;
    }

    @Override
    public CreateContentActionRequestExecutor forDevices(String ... uniqueIds) {
        super.forDevices(uniqueIds);
        return this;
    }

    @Override
    public CreateContentActionRequestExecutor forDevices(List<String> uniqueIds) {
        super.forDevices(uniqueIds);
        return this;
    }

    @Override
    public CreateContentActionRequestExecutor withProximity(Proximity proximity) {
        super.withProximity(proximity);
        return this;
    }

    @Override
    protected Call<Action> prepareCall() {
        if (this.isMultipart) {
            RequestBody uniqueIdParam = RequestBody.create((MediaType)MediaType.parse((String)"multipart/form-data"), (String)StringUtils.join(this.uniqueIds, ","));
            RequestBody actionTypeParam = RequestBody.create((MediaType)MediaType.parse((String)"multipart/form-data"), (String)this.actionType.name());
            RequestBody proximityParam = RequestBody.create((MediaType)MediaType.parse((String)"multipart/form-data"), (String)this.proximity.name());
            RequestBody requestFile = RequestBody.create((MediaType)MediaType.parse((String)"multipart/form-data"), (File)this.file);
            MultipartBody.Part fileParam = MultipartBody.Part.createFormData((String)"file", (String)this.file.getName(), (RequestBody)requestFile);
            return this.actionsService.createContentActionWithMultipart(uniqueIdParam, actionTypeParam, proximityParam, fileParam);
        }
        return super.prepareCall();
    }

    @Override
    protected void checkPreconditions() {
        SDKPreconditions.checkState(this.uniqueIds != null, "cannot create action - specify devices");
        SDKPreconditions.checkState(this.actionType != null, "cannot create action - specify action type");
        SDKPreconditions.checkState(this.proximity != null, "cannot create action - specify proximity");
        SDKPreconditions.checkState(this.encodedFile != null, "cannot create action - specify media file");
    }

    @Override
    protected Map<String, String> params() {
        Map<String, String> params = super.params();
        params.put("file", this.encodedFile);
        return params;
    }
}

