/*
 * Decompiled with CFR 0.152.
 */
package com.kontakt.sdk.android.cloud.api;

import com.kontakt.sdk.android.cloud.api.executor.devices.ApplySecureConfigRequestExecutor;
import com.kontakt.sdk.android.cloud.api.executor.devices.AssignDeviceRequestExecutor;
import com.kontakt.sdk.android.cloud.api.executor.devices.CredentialsListRequestExecutor;
import com.kontakt.sdk.android.cloud.api.executor.devices.CredentialsRequestExecutor;
import com.kontakt.sdk.android.cloud.api.executor.devices.DevicesFromUrlRequestExecutor;
import com.kontakt.sdk.android.cloud.api.executor.devices.DevicesRequestExecutor;
import com.kontakt.sdk.android.cloud.api.executor.devices.EddystonesRequestExecutor;
import com.kontakt.sdk.android.cloud.api.executor.devices.IBeaconsRequestExecutor;
import com.kontakt.sdk.android.cloud.api.executor.devices.MoveDeviceRequestExecutor;
import com.kontakt.sdk.android.cloud.api.executor.devices.RegisterDeviceRequestExecutor;
import com.kontakt.sdk.android.cloud.api.executor.devices.ShareDeviceRequestExecutor;
import com.kontakt.sdk.android.cloud.api.executor.devices.TelemetryRequestExecutor;
import com.kontakt.sdk.android.cloud.api.executor.devices.UnassignDeviceRequestExecutor;
import com.kontakt.sdk.android.cloud.api.executor.devices.UnshareDeviceRequestExecutor;
import com.kontakt.sdk.android.cloud.api.executor.devices.UpdateDeviceRequestExecutor;
import com.kontakt.sdk.android.cloud.api.service.DevicesService;
import com.kontakt.sdk.android.common.model.Config;
import com.kontakt.sdk.android.common.util.SDKPreconditions;
import java.util.List;
import java.util.UUID;

public class DevicesApi {
    private final DevicesService devicesService;

    public DevicesApi(DevicesService devicesService) {
        this.devicesService = devicesService;
    }

    public DevicesRequestExecutor fetch() {
        return new DevicesRequestExecutor(this.devicesService);
    }

    public DevicesFromUrlRequestExecutor fetchFromUrl(String url) {
        SDKPreconditions.checkNotNullOrEmpty(url, "url cannot be either null or empty");
        return new DevicesFromUrlRequestExecutor(this.devicesService, url);
    }

    public EddystonesRequestExecutor eddystones() {
        return new EddystonesRequestExecutor(this.devicesService);
    }

    public IBeaconsRequestExecutor iBeacons() {
        return new IBeaconsRequestExecutor(this.devicesService);
    }

    public CredentialsRequestExecutor credentials(String uniqueId) {
        SDKPreconditions.checkNotNull(uniqueId, "ID cannot be null");
        return new CredentialsRequestExecutor(this.devicesService, uniqueId);
    }

    public CredentialsListRequestExecutor credentials(List<String> uniqueIds) {
        SDKPreconditions.checkNotNull(uniqueIds, "IDs cannot be null");
        return new CredentialsListRequestExecutor(this.devicesService, uniqueIds);
    }

    public TelemetryRequestExecutor decryptTelemetry(String eid, String etlmFrame) {
        SDKPreconditions.checkNotNull(eid, "EID cannot be null");
        SDKPreconditions.checkNotNull(etlmFrame, "ETLM cannot be null");
        return new TelemetryRequestExecutor(this.devicesService, eid, etlmFrame);
    }

    public UpdateDeviceRequestExecutor update(String uniqueId) {
        SDKPreconditions.checkNotNull(uniqueId, "ID cannot be null");
        return new UpdateDeviceRequestExecutor(this.devicesService, uniqueId);
    }

    public AssignDeviceRequestExecutor assign(UUID ... deviceIds) {
        SDKPreconditions.checkNotNull(deviceIds, "IDs cannot be null");
        return new AssignDeviceRequestExecutor(this.devicesService, deviceIds);
    }

    public AssignDeviceRequestExecutor assign(String ... uniqueIds) {
        SDKPreconditions.checkNotNull(uniqueIds, "IDs cannot be null");
        return new AssignDeviceRequestExecutor(this.devicesService, uniqueIds);
    }

    public UnassignDeviceRequestExecutor unassignFromVenue(String ... uniqueIds) {
        SDKPreconditions.checkNotNull(uniqueIds, "IDs cannot be null");
        return new UnassignDeviceRequestExecutor(this.devicesService, uniqueIds);
    }

    public UnassignDeviceRequestExecutor unassignFromVenue(List<String> uniqueIds) {
        SDKPreconditions.checkNotNull(uniqueIds, "IDs cannot be null");
        return new UnassignDeviceRequestExecutor(this.devicesService, uniqueIds);
    }

    public MoveDeviceRequestExecutor move(String ... uniqueIds) {
        SDKPreconditions.checkNotNull(uniqueIds, "IDs cannot be null");
        return new MoveDeviceRequestExecutor(this.devicesService, uniqueIds);
    }

    public MoveDeviceRequestExecutor move(List<String> uniqueIds) {
        SDKPreconditions.checkNotNull(uniqueIds, "IDs cannot be null");
        return new MoveDeviceRequestExecutor(this.devicesService, uniqueIds);
    }

    public ShareDeviceRequestExecutor share(String ... uniqueIds) {
        SDKPreconditions.checkNotNull(uniqueIds, "IDs cannot be null");
        return new ShareDeviceRequestExecutor(this.devicesService, uniqueIds);
    }

    public ShareDeviceRequestExecutor share(List<String> uniqueIds) {
        SDKPreconditions.checkNotNull(uniqueIds, "IDs cannot be null");
        return new ShareDeviceRequestExecutor(this.devicesService, uniqueIds);
    }

    public UnshareDeviceRequestExecutor unshare(String ... uniqueIds) {
        SDKPreconditions.checkNotNull(uniqueIds, "IDs cannot be null");
        return new UnshareDeviceRequestExecutor(this.devicesService, uniqueIds);
    }

    public UnshareDeviceRequestExecutor unshare(List<String> uniqueIds) {
        SDKPreconditions.checkNotNull(uniqueIds, "IDs cannot be null");
        return new UnshareDeviceRequestExecutor(this.devicesService, uniqueIds);
    }

    public ApplySecureConfigRequestExecutor applySecureConfigs(Config ... configs) {
        SDKPreconditions.checkNotNull(configs, "configs cannot be null");
        return new ApplySecureConfigRequestExecutor(this.devicesService, configs);
    }

    public ApplySecureConfigRequestExecutor applySecureConfigs(List<Config> configs) {
        SDKPreconditions.checkNotNull(configs, "configs cannot be null");
        return new ApplySecureConfigRequestExecutor(this.devicesService, configs);
    }

    public RegisterDeviceRequestExecutor register(String sourceId) {
        SDKPreconditions.checkNotNull(sourceId);
        return new RegisterDeviceRequestExecutor(this.devicesService, sourceId);
    }
}

