/*
 * Decompiled with CFR 0.152.
 */
package com.kontakt.sdk.android.ble.spec;

public enum EddystoneFrameType {
    UID(0),
    URL(16),
    TLM(32),
    EID(48);

    private static final int FRAME_TYPE_MASK = 240;
    private static final int FRAME_TYPE_BYTE_POSITION = 11;
    private final int binaryRepresentation;

    private EddystoneFrameType(int binaryRepresentation) {
        this.binaryRepresentation = binaryRepresentation;
    }

    public static EddystoneFrameType fromScanRecord(byte[] scanRecord) {
        byte frameType = scanRecord[11] = (byte)(scanRecord[11] & 0xF0);
        for (EddystoneFrameType eddystoneFrameType : EddystoneFrameType.values()) {
            if (eddystoneFrameType.binaryRepresentation != frameType) continue;
            return eddystoneFrameType;
        }
        return null;
    }
}

