/*
 * Decompiled with CFR 0.152.
 */
package com.kontakt.sdk.android.ble.security.property;

import com.kontakt.sdk.android.ble.security.property.AbstractProperty;
import com.kontakt.sdk.android.ble.security.property.PropertyID;
import com.kontakt.sdk.android.common.util.SDKPreconditions;

public class UInt16Property
extends AbstractProperty<Short> {
    private static final int UINT16_SIZE = 2;
    private int value;

    public UInt16Property(PropertyID id, int value) {
        super(id);
        this.value = value;
    }

    public UInt16Property(PropertyID id, byte[] value) {
        super(id);
        SDKPreconditions.checkArgument(value.length == 2);
        this.value = (value[0] & 0xFF) + (value[1] << 8 & 0xFF00);
    }

    @Override
    public byte[] getBytes() {
        byte[] result = new byte[]{(byte)(this.value & 0xFF), (byte)((this.value & 0xFF00) >>> 8)};
        return result;
    }

    @Override
    public byte getSize() {
        return 2;
    }

    @Override
    public Short getValue() {
        return (short)this.value;
    }
}

