/*
 * Decompiled with CFR 0.152.
 */
package com.kontakt.sdk.android.ble.security.property;

import com.kontakt.sdk.android.ble.security.property.PropertyDataType;

public enum PropertyID {
    PROXIMITY_UUID(33041, PropertyDataType.BYTE_ARRAY),
    MAJOR(33042, PropertyDataType.UINT16),
    MINOR(33043, PropertyDataType.UINT16),
    NAME(33044, PropertyDataType.STRING),
    BEACON_ID(33045, PropertyDataType.STRING),
    REF_TX_1M(33046, PropertyDataType.BYTE_ARRAY),
    NAMESPACE_ID(33047, PropertyDataType.BYTE_ARRAY),
    INSTANCE_ID(33048, PropertyDataType.BYTE_ARRAY),
    URL(33049, PropertyDataType.BYTE_ARRAY),
    REF_TX_0M(33050, PropertyDataType.BYTE_ARRAY),
    INTERVAL(33057, PropertyDataType.UINT16),
    SET_PASSWORD(33074, PropertyDataType.STRING),
    SHUFFLE_INTERVAL(33080, PropertyDataType.UINT16),
    ACTIVE_PROFILE(33082, PropertyDataType.UINT8),
    TX_POWER(10759, PropertyDataType.INT8),
    EDDY_EID_SCALER(33052, PropertyDataType.UINT8),
    BEACON_PACKETS_MASK(33054, PropertyDataType.UINT32),
    POWER_SAVER_FEATURES_MASK(33536, PropertyDataType.UINT32),
    MOVE_SUSPEND_TIMEOUT(33537, PropertyDataType.UINT32),
    LIGHT_SENSOR_THRESHOLD(33538, PropertyDataType.INT8),
    LIGHT_SENSOR_HIST(33539, PropertyDataType.INT8),
    LIGHT_SENSOR_SAMPLING_INTERVAL(33540, PropertyDataType.UINT32),
    WIFI_SSID(33281, PropertyDataType.STRING),
    WIFI_USER(33282, PropertyDataType.STRING),
    WIFI_PASS(33283, PropertyDataType.STRING),
    WIFI_PROTOCOL(33284, PropertyDataType.INT8),
    API_KEY(33285, PropertyDataType.STRING),
    TERMINATING(65535, PropertyDataType.NONE);

    private final short value;
    private final PropertyDataType type;

    private PropertyID(int value, PropertyDataType type) {
        this.type = type;
        this.value = (short)value;
    }

    public short getValue() {
        return this.value;
    }

    public PropertyDataType getDataType() {
        return this.type;
    }

    public static PropertyID of(short value) {
        PropertyID[] arr = PropertyID.values();
        int len = arr.length;
        for (int i = 0; i < len; ++i) {
            if (arr[i].getValue() != value) continue;
            return arr[i];
        }
        return null;
    }
}

