/*
 * Decompiled with CFR 0.152.
 */
package com.kontakt.sdk.android.ble.security.property;

import com.kontakt.sdk.android.ble.security.property.AbstractProperty;
import com.kontakt.sdk.android.ble.security.property.PropertyID;
import com.kontakt.sdk.android.common.util.SDKPreconditions;

public class Int8Property
extends AbstractProperty<Byte> {
    private static final int INT8_SIZE = 1;
    private final int value;

    public Int8Property(PropertyID id, int value) {
        super(id);
        SDKPreconditions.checkArgument(value <= 127 && value >= -128, "Invalid uint value.");
        this.value = value;
    }

    public Int8Property(PropertyID id, byte[] value) {
        super(id);
        SDKPreconditions.checkArgument(value.length == 1);
        this.value = value[0];
    }

    @Override
    public byte[] getBytes() {
        return new byte[]{(byte)this.value};
    }

    @Override
    public byte getSize() {
        return 1;
    }

    @Override
    public Byte getValue() {
        return (byte)this.value;
    }
}

