/*
 * Decompiled with CFR 0.152.
 */
package com.kontakt.sdk.android.ble.discovery.eddystone;

import com.kontakt.sdk.android.ble.discovery.eddystone.EddystonePropertyResolver;
import com.kontakt.sdk.android.common.util.ConversionUtils;

public final class NamespaceIdResolver
implements EddystonePropertyResolver<String> {
    public static final int DEFAULT_NAMESPACE_ID_START_INDEX = 4;
    public static final int SECURE_PROFILE_NAMESPACE_ID_START_INDEX = 8;
    private static final int NAMESPACE_ID_LENGTH = 10;
    private static final int MASK = 255;
    private static final String FORMAT = "%02x";
    private final StringBuilder stringBuilder = new StringBuilder();
    private final int namespaceStartIndex;

    public NamespaceIdResolver(int namespaceStartIndex) {
        this.namespaceStartIndex = namespaceStartIndex;
    }

    @Override
    public String parse(byte[] packet) {
        if (packet == null) {
            return null;
        }
        byte[] bytes = ConversionUtils.extractEddystonePacketPayload(packet, this.namespaceStartIndex, 10);
        if (bytes == null) {
            return null;
        }
        this.stringBuilder.setLength(0);
        for (byte byteValue : bytes) {
            this.stringBuilder.append(String.format(FORMAT, byteValue & 0xFF));
        }
        return this.stringBuilder.toString();
    }
}

