/*
 * Decompiled with CFR 0.152.
 */
package com.kontakt.sdk.android.ble.discovery.eddystone;

import android.os.Bundle;
import android.os.Parcel;
import android.os.Parcelable;
import com.kontakt.sdk.android.ble.discovery.AbstractBluetoothDeviceEvent;
import com.kontakt.sdk.android.ble.discovery.EventType;
import com.kontakt.sdk.android.common.profile.DeviceProfile;
import com.kontakt.sdk.android.common.profile.IEddystoneDevice;
import com.kontakt.sdk.android.common.profile.IEddystoneNamespace;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

public class EddystoneDeviceEvent
extends AbstractBluetoothDeviceEvent {
    public static final Parcelable.Creator<EddystoneDeviceEvent> CREATOR = new Parcelable.Creator<EddystoneDeviceEvent>(){

        public EddystoneDeviceEvent createFromParcel(Parcel source) {
            Bundle bundle = source.readBundle(this.getClass().getClassLoader());
            EventType eventType = (EventType)((Object)bundle.getSerializable("kontakt_event_type"));
            IEddystoneNamespace IEddystoneNamespace2 = (IEddystoneNamespace)bundle.getParcelable("namespace");
            ArrayList deviceList = bundle.getParcelableArrayList("remote_device_list");
            long timestamp = bundle.getLong("timestamp");
            return new EddystoneDeviceEvent(eventType, IEddystoneNamespace2, deviceList, timestamp);
        }

        public EddystoneDeviceEvent[] newArray(int size) {
            return new EddystoneDeviceEvent[size];
        }
    };
    private final IEddystoneNamespace iEddystoneNamespace;

    public EddystoneDeviceEvent(EventType eventType, IEddystoneNamespace iEddystoneNamespace, List<IEddystoneDevice> deviceList) {
        this(eventType, iEddystoneNamespace, deviceList, System.currentTimeMillis());
    }

    EddystoneDeviceEvent(EventType eventType, IEddystoneNamespace iEddystoneNamespace, List<IEddystoneDevice> deviceList, long timestamp) {
        super(eventType, DeviceProfile.EDDYSTONE, deviceList, timestamp);
        this.iEddystoneNamespace = iEddystoneNamespace;
    }

    public IEddystoneNamespace getNamespace() {
        return this.iEddystoneNamespace;
    }

    public List<IEddystoneDevice> getDeviceList() {
        return super.getDeviceList();
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        Bundle bundle = new Bundle(this.getClass().getClassLoader());
        bundle.putParcelable("namespace", (Parcelable)this.iEddystoneNamespace);
        bundle.putSerializable("kontakt_event_type", (Serializable)((Object)this.getEventType()));
        bundle.putParcelableArrayList("remote_device_list", (ArrayList)this.deviceList);
        bundle.putLong("timestamp", this.timestamp);
        dest.writeBundle(bundle);
    }

    public static EddystoneDeviceEvent of(EddystoneDeviceEvent eddystoneDeviceEvent, List<IEddystoneDevice> eddystoneDevices) {
        return new EddystoneDeviceEvent(eddystoneDeviceEvent.getEventType(), eddystoneDeviceEvent.getNamespace(), eddystoneDevices, eddystoneDeviceEvent.getTimestamp());
    }
}

