/*
 * Decompiled with CFR 0.152.
 */
package com.kontakt.sdk.android.ble.discovery;

import com.kontakt.sdk.android.common.profile.DeviceProfile;
import com.kontakt.sdk.android.common.util.SDKPreconditions;

public final class DiscoveryUtils {
    private DiscoveryUtils() {
    }

    public static double calculateDistance(int txPower, double rssi, DeviceProfile profile) {
        SDKPreconditions.checkNotNull(profile, "Profile can't be null");
        if (rssi == 0.0) {
            return -1.0;
        }
        int normalizedTxPower = profile == DeviceProfile.EDDYSTONE ? txPower - 41 : txPower;
        double ratio = rssi * 1.0 / (double)normalizedTxPower;
        if (ratio < 1.0) {
            return Math.pow(ratio, 10.0);
        }
        return 0.89976 * Math.pow(ratio, 7.7095) + 0.111;
    }
}

