/*
 * Decompiled with CFR 0.152.
 */
package com.kontakt.sdk.android.ble.connection;

import android.util.Base64;
import com.kontakt.sdk.android.ble.connection.ErrorCause;
import com.kontakt.sdk.android.ble.connection.KontaktDeviceConnection;
import com.kontakt.sdk.android.ble.connection.KontaktDeviceConnectionImpl;
import com.kontakt.sdk.android.ble.connection.ReadListener;
import com.kontakt.sdk.android.ble.connection.SecureConfigMapper;
import com.kontakt.sdk.android.ble.connection.WriteListener;
import com.kontakt.sdk.android.ble.security.EncryptedWriteRequest;
import com.kontakt.sdk.android.ble.security.ResponseCode;
import com.kontakt.sdk.android.ble.security.auth.AuthToken;
import com.kontakt.sdk.android.ble.security.exception.InvalidConfigException;
import com.kontakt.sdk.android.ble.security.parser.SimpleResponseParser;
import com.kontakt.sdk.android.common.model.Config;

class OfflineSecurityService {
    KontaktDeviceConnection connection;
    WriteListener writeListener = WriteListener.NOOP_LISTENER;
    AuthToken authToken;
    Config configToApply;
    private final WriteListener internalWriteListener = new WriteListener(){

        @Override
        public void onWriteSuccess(WriteListener.WriteResponse response) {
            if (OfflineSecurityService.this.connection != null) {
                OfflineSecurityService.this.checkWriteResponse(response);
            }
        }

        @Override
        public void onWriteFailure(ErrorCause cause) {
            OfflineSecurityService.this.writeListener.onWriteFailure(cause);
        }
    };
    private final ReadListener<Config> internalReadListener = new ReadListener<Config>(){

        @Override
        public void onReadSuccess(Config readConfig) {
            OfflineSecurityService.this.unregisterListeners();
            OfflineSecurityService.this.validateConfig(readConfig);
        }

        @Override
        public void onReadFailure(ErrorCause cause) {
            OfflineSecurityService.this.unregisterListeners();
            OfflineSecurityService.this.writeListener.onWriteFailure(cause);
        }
    };

    OfflineSecurityService(KontaktDeviceConnection kontaktDeviceConnection) {
        this.connection = kontaktDeviceConnection;
    }

    void close() {
        this.connection = null;
    }

    void applySecureConfig(Config config, AuthToken token, WriteListener writeListener) {
        this.configToApply = config;
        this.writeListener = writeListener;
        this.authToken = token;
        this.connection.readAll(this.authToken, this.internalReadListener);
    }

    void validateConfig(Config readConfig) {
        if (this.configToApply.isShuffled()) {
            this.writeListener.onWriteFailure(ErrorCause.OPERATION_NOT_ALLOWED);
            return;
        }
        if (readConfig.isShuffled() && this.isAnyForbiddenPropertyChanged(this.configToApply)) {
            this.writeListener.onWriteFailure(ErrorCause.OPERATION_NOT_ALLOWED);
            return;
        }
        this.sendSecureConfig(this.configToApply);
    }

    void sendSecureConfig(Config config) {
        int timestampToken = (int)(System.currentTimeMillis() / 1000L);
        EncryptedWriteRequest request = new EncryptedWriteRequest(timestampToken, SecureConfigMapper.toSecureProperties(config), this.authToken.getPassword());
        this.connection.applySecureConfig(request.getBase64Data(), this.internalWriteListener);
    }

    void checkWriteResponse(WriteListener.WriteResponse response) {
        byte[] decodedBase = Base64.decode((String)response.getExtra(), (int)0);
        try {
            SimpleResponseParser responseParser = SimpleResponseParser.of(decodedBase, this.authToken.getPassword());
            ResponseCode result = responseParser.getResult();
            switch (result) {
                case OK: {
                    this.writeListener.onWriteSuccess(response);
                    break;
                }
                case VERIFICATION_FAILED: {
                    this.writeListener.onWriteFailure(ErrorCause.VERIFICATION_FAILED);
                    break;
                }
                case AUTHORIZATION_FAILED: {
                    this.writeListener.onWriteFailure(ErrorCause.AUTHORIZATION_FAILED);
                    break;
                }
                case ID_NOT_FOUND: {
                    this.writeListener.onWriteFailure(ErrorCause.ID_NOT_FOUND);
                    break;
                }
                default: {
                    this.writeListener.onWriteFailure(ErrorCause.INCORRECT_RESPONSE);
                    break;
                }
            }
        }
        catch (InvalidConfigException e) {
            this.writeListener.onWriteFailure(ErrorCause.INCORRECT_RESPONSE);
        }
    }

    private boolean isAnyForbiddenPropertyChanged(Config configToApply) {
        return configToApply.getProximity() != null || configToApply.getMajor() > 0 || configToApply.getMinor() > 0 || configToApply.getNamespace() != null || configToApply.getInstanceId() != null || configToApply.isShuffled();
    }

    void unregisterListeners() {
        if (this.connection != null) {
            ((KontaktDeviceConnectionImpl)this.connection).unregisterAllListeners();
        }
    }
}

