/*
 * Decompiled with CFR 0.152.
 */
package com.kontakt.sdk.android.ble.cache;

import com.kontakt.sdk.android.ble.cache.IBeaconResolveRequest;
import com.kontakt.sdk.android.ble.cache.IBeaconResolveStrategy;
import com.kontakt.sdk.android.ble.cache.ResolveRequestStatus;
import com.kontakt.sdk.android.ble.cache.ResolverType;
import com.kontakt.sdk.android.cloud.KontaktCloud;
import com.kontakt.sdk.android.cloud.exception.KontaktCloudException;
import com.kontakt.sdk.android.cloud.response.paginated.Devices;
import com.kontakt.sdk.android.common.model.Device;
import com.kontakt.sdk.android.common.model.IBeaconFutureId;
import com.kontakt.sdk.android.common.model.IBeaconId;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

class IBeaconApiResolveStrategy
implements IBeaconResolveStrategy {
    private final KontaktCloud kontaktCloud;

    IBeaconApiResolveStrategy(KontaktCloud kontaktCloud) {
        this.kontaktCloud = kontaktCloud;
    }

    @Override
    public List<IBeaconFutureId> resolve(Map<IBeaconId, IBeaconResolveRequest> requests) throws Exception {
        List<IBeaconId> toResolve = this.iBeaconsToResolve(requests);
        if (toResolve.isEmpty()) {
            return Collections.emptyList();
        }
        List<IBeaconFutureId> futureIds = this.resolveIBeacons(toResolve);
        this.updateRequests(requests, futureIds);
        return futureIds;
    }

    private List<IBeaconId> iBeaconsToResolve(Map<IBeaconId, IBeaconResolveRequest> requests) {
        ArrayList<IBeaconId> toResolve = new ArrayList<IBeaconId>();
        for (Map.Entry<IBeaconId, IBeaconResolveRequest> entry : requests.entrySet()) {
            IBeaconResolveRequest request = entry.getValue();
            if (ResolveRequestStatus.RESOLVED == request.getStatus()) continue;
            toResolve.add(entry.getKey());
        }
        return toResolve;
    }

    private List<IBeaconFutureId> resolveIBeacons(List<IBeaconId> ids) throws IOException, KontaktCloudException {
        Devices cloudResult = (Devices)this.kontaktCloud.devices().iBeacons().withIds(ids).execute();
        Object devices = cloudResult.getContent();
        ArrayList<IBeaconFutureId> futureIds = new ArrayList<IBeaconFutureId>();
        Iterator iterator = devices.iterator();
        while (iterator.hasNext()) {
            Device device = (Device)iterator.next();
            IBeaconFutureId iBeaconFutureId = device.extractIBeaconFutureId();
            if (iBeaconFutureId == null) continue;
            futureIds.add(iBeaconFutureId);
        }
        return futureIds;
    }

    private void updateRequests(Map<IBeaconId, IBeaconResolveRequest> requests, List<IBeaconFutureId> futureIds) {
        for (IBeaconFutureId id : futureIds) {
            this.updateRequest(requests, id);
        }
    }

    private void updateRequest(Map<IBeaconId, IBeaconResolveRequest> requests, IBeaconFutureId id) {
        IBeaconResolveRequest request = requests.get(id.getQueriedBy());
        request.setResolvedBy(ResolverType.API);
        if (ResolveRequestStatus.IGNORED == request.getStatus()) {
            return;
        }
        request.setStatus(ResolveRequestStatus.RESOLVED);
    }
}

