package com.kontakt.sdk.android.cloud;

import com.kontakt.sdk.android.common.KontaktSDK;

public class KontaktCloudFactory {

  public static final String API_URL = "https://api.kontakt.io";
  public static final int API_VERSION = 10;

  /**
   * Provides new instance of Kontakt Cloud. Please make sure that {@link KontaktSDK} is
   * already initialized with the proper API key.
   *
   * @return the Kontakt.io Proximity REST API client.
   */
  public static KontaktCloud create() {
    return create(KontaktSDK.getInstance().getApiKey());
  }

  /**
   * Provides new instance of Kontakt Cloud initialized with given API key.
   *
   * @param apiKey the user's API key.
   * @return the Kontakt.io Proximity REST API client.
   */
  public static KontaktCloud create(String apiKey) {
    return new KontaktCloudImpl(apiKey, API_URL, API_VERSION);
  }

}
