package com.kontakt.sdk.android.ble.manager.listeners;

import com.kontakt.sdk.android.common.profile.IBeaconDevice;
import com.kontakt.sdk.android.common.profile.IBeaconRegion;
import com.kontakt.sdk.android.common.profile.IEddystoneDevice;
import com.kontakt.sdk.android.common.profile.IEddystoneNamespace;
import java.util.List;

/**
 * Listener used to report Eddystone scanning results.
 */
public interface EddystoneListener {

  /**
   * Called when Eddystone is discovered for the first time. This will be called only once per scan or after beacon is reported lost.
   *
   * @param eddystone {@link IEddystoneDevice} instance.
   * @param namespace {@link IEddystoneNamespace} instance.
   */
  void onEddystoneDiscovered(IEddystoneDevice eddystone, IEddystoneNamespace namespace);

  /**
   * Called when Eddystones are updated.
   *
   * @param eddystones List of updated {@link IEddystoneDevice} devices.
   * @param namespace {@link IEddystoneNamespace} instance.
   */
  void onEddystonesUpdated(List<IEddystoneDevice> eddystones, IEddystoneNamespace namespace);

  /**
   * Called when Eddystone is reported lost (out of range). onEddystoneDiscovered will be called when beacon is back in range.
   *
   * @param eddystone Lost {@link IBeaconDevice} instance.
   * @param namespace {@link IBeaconRegion} instance.
   */
  void onEddystoneLost(IEddystoneDevice eddystone, IEddystoneNamespace namespace);
}
