package com.kontakt.sdk.android.ble.connection;

import com.kontakt.sdk.android.common.model.Network;

public interface KontaktGatewayConnection extends KontaktDeviceConnection {

  /**
   * Read will initialize networks array. This array will be sorted by RSSI (highest on index 0).
   * It is guaranteed that networks array won't change between reads.
   */
  void readNetworksCount(ReadListener<Integer> listener);

  void selectNetworkToRead(int index, WriteListener listener);

  void readSelectedNetwork(ReadListener<Network> listener);
}
