/*
 * Decompiled with CFR 0.152.
 */
package com.kontakt.sdk.android.common.model;

import android.os.Parcel;
import android.os.Parcelable;
import com.kontakt.sdk.android.common.model.EventType;
import com.kontakt.sdk.android.common.profile.RemoteBluetoothDevice;
import com.kontakt.sdk.android.common.util.SDKPreconditions;

public class Event
implements Parcelable {
    public static final Parcelable.Creator<Event> CREATOR = new Parcelable.Creator<Event>(){

        public Event createFromParcel(Parcel source) {
            return new Event(source);
        }

        public Event[] newArray(int size) {
            return new Event[size];
        }
    };
    private final EventType type;
    private final long timestamp;
    private final String uniqueId;
    private final String deviceAddress;
    private final int batteryLevel;
    private final double rssi;

    public static Builder builder() {
        return new Builder();
    }

    Event(Builder builder) {
        this.type = builder.type;
        this.timestamp = builder.timestamp / 1000L;
        this.uniqueId = builder.uniqueId;
        this.deviceAddress = builder.deviceAddress;
        this.batteryLevel = builder.batteryLevel;
        this.rssi = builder.rssi;
    }

    protected Event(Parcel in) {
        int tmpEventType = in.readInt();
        this.type = tmpEventType == -1 ? null : EventType.values()[tmpEventType];
        this.timestamp = in.readLong();
        this.uniqueId = in.readString();
        this.deviceAddress = in.readString();
        this.batteryLevel = in.readInt();
        this.rssi = in.readDouble();
    }

    public static Event of(RemoteBluetoothDevice device, EventType eventType) {
        SDKPreconditions.checkNotNull(device, "device cannot be null");
        SDKPreconditions.checkNotNull(eventType, "event type cannot be null");
        switch (eventType) {
            case SCAN: {
                return Event.scanEvent(device);
            }
            case MONITORING: {
                return Event.monitoringEvent(device);
            }
        }
        throw new IllegalArgumentException("invalid event type");
    }

    private static Event scanEvent(RemoteBluetoothDevice device) {
        return new Builder().type(EventType.SCAN).timestamp(device.getTimestamp()).uniqueId(device.getUniqueId()).deviceAddress(device.getAddress()).rssi(device.getRssi()).batteryLevel(device.getBatteryPower()).build();
    }

    private static Event monitoringEvent(RemoteBluetoothDevice device) {
        return new Builder().type(EventType.MONITORING).timestamp(device.getTimestamp()).uniqueId(device.getUniqueId()).deviceAddress(device.getAddress()).batteryLevel(device.getBatteryPower()).build();
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        dest.writeInt(this.type == null ? -1 : this.type.ordinal());
        dest.writeLong(this.timestamp);
        dest.writeString(this.uniqueId);
        dest.writeString(this.deviceAddress);
        dest.writeInt(this.batteryLevel);
        dest.writeDouble(this.rssi);
    }

    public EventType getType() {
        return this.type;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public String getUniqueId() {
        return this.uniqueId;
    }

    public String getDeviceAddress() {
        return this.deviceAddress;
    }

    public int getBatteryLevel() {
        return this.batteryLevel;
    }

    public double getRssi() {
        return this.rssi;
    }

    public static class Builder {
        EventType type;
        long timestamp;
        String uniqueId;
        String deviceAddress;
        int batteryLevel;
        double rssi;

        public Builder type(EventType type) {
            this.type = type;
            return this;
        }

        public Builder timestamp(long timestamp) {
            this.timestamp = timestamp;
            return this;
        }

        public Builder uniqueId(String uniqueId) {
            this.uniqueId = uniqueId;
            return this;
        }

        public Builder deviceAddress(String deviceAddress) {
            this.deviceAddress = deviceAddress;
            return this;
        }

        public Builder batteryLevel(int batteryLevel) {
            this.batteryLevel = batteryLevel;
            return this;
        }

        public Builder rssi(double rssi) {
            this.rssi = rssi;
            return this;
        }

        public Event build() {
            return new Event(this);
        }
    }
}

