/*
 * Decompiled with CFR 0.152.
 */
package com.kontakt.sdk.android.cloud.api.executor.commands;

import com.kontakt.sdk.android.cloud.api.executor.PaginatedRequestExecutor;
import com.kontakt.sdk.android.cloud.api.service.CommandsService;
import com.kontakt.sdk.android.cloud.exception.KontaktCloudException;
import com.kontakt.sdk.android.cloud.response.CloudCallback;
import com.kontakt.sdk.android.cloud.response.paginated.SecureCommands;
import com.kontakt.sdk.android.cloud.util.StringUtils;
import com.kontakt.sdk.android.common.Order;
import com.kontakt.sdk.android.common.model.OrderBy;
import com.kontakt.sdk.android.common.model.SecureCommandType;
import com.kontakt.sdk.android.common.util.SDKPreconditions;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import retrofit2.Call;

public class CommandsRequestExecutor
extends PaginatedRequestExecutor<SecureCommands> {
    private final CommandsService commandsService;
    private String[] uniqueIds;
    private SecureCommandType type;

    public CommandsRequestExecutor(CommandsService commandsService) {
        this.commandsService = commandsService;
    }

    public CommandsRequestExecutor forDevices(String ... uniqueIds) {
        this.uniqueIds = SDKPreconditions.checkNotNull(uniqueIds, "IDs cannot be null");
        return this;
    }

    public CommandsRequestExecutor forDevices(List<String> uniqueIds) {
        SDKPreconditions.checkNotNull(uniqueIds, "IDs cannot be null");
        int size = uniqueIds.size();
        this.uniqueIds = uniqueIds.toArray(new String[size]);
        return this;
    }

    public CommandsRequestExecutor withType(SecureCommandType type) {
        this.type = SDKPreconditions.checkNotNull(type, "type cannot be null");
        return this;
    }

    @Override
    public CommandsRequestExecutor startIndex(int startIndex) {
        super.startIndex(startIndex);
        return this;
    }

    @Override
    public CommandsRequestExecutor maxResult(int maxResult) {
        super.startIndex(maxResult);
        return this;
    }

    @Override
    public CommandsRequestExecutor filter(String query) {
        super.filter(query);
        return this;
    }

    @Override
    public CommandsRequestExecutor orderBy(OrderBy orderBy, Order order) {
        super.orderBy(orderBy, order);
        return this;
    }

    @Override
    public CommandsRequestExecutor eTag(String eTag) {
        super.eTag(eTag);
        return this;
    }

    @Override
    public SecureCommands execute() throws IOException, KontaktCloudException {
        this.checkPreconditions();
        return (SecureCommands)super.execute();
    }

    @Override
    public void execute(CloudCallback<SecureCommands> callback) {
        this.checkPreconditions();
        super.execute(callback);
    }

    @Override
    protected Call<SecureCommands> prepareCall() {
        return this.commandsService.getSecureCommands(this.params());
    }

    private void checkPreconditions() {
        SDKPreconditions.checkState(this.uniqueIds != null, "Cannot get commands - specify devices");
        SDKPreconditions.checkState(this.type != null, "Cannot get commands - specify command type");
    }

    @Override
    protected Map<String, String> params() {
        Map<String, String> params = super.params();
        params.put("uniqueId", StringUtils.join(this.uniqueIds, ","));
        params.put("command", this.type.name());
        return params;
    }
}

