/*
 * Decompiled with CFR 0.152.
 */
package com.kontakt.sdk.android.cloud.api.executor.activities;

import com.kontakt.sdk.android.cloud.api.executor.PaginatedRequestExecutor;
import com.kontakt.sdk.android.cloud.api.service.ActivitiesService;
import com.kontakt.sdk.android.cloud.response.paginated.Activities;
import com.kontakt.sdk.android.cloud.util.StringUtils;
import com.kontakt.sdk.android.common.Order;
import com.kontakt.sdk.android.common.model.OrderBy;
import com.kontakt.sdk.android.common.util.SDKPreconditions;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import retrofit2.Call;

public class ActivitiesRequestExecutor
extends PaginatedRequestExecutor<Activities> {
    private final ActivitiesService activitiesService;
    private final List<UUID> activitiesIds = new ArrayList<UUID>();

    public ActivitiesRequestExecutor(ActivitiesService service) {
        this.activitiesService = service;
    }

    public ActivitiesRequestExecutor withIds(UUID ... ids) {
        return this.withIds(Arrays.asList(ids));
    }

    public ActivitiesRequestExecutor withIds(List<UUID> ids) {
        SDKPreconditions.checkNotNull(ids, "Ids are null");
        this.activitiesIds.addAll(ids);
        return this;
    }

    @Override
    public ActivitiesRequestExecutor startIndex(int startIndex) {
        super.startIndex(startIndex);
        return this;
    }

    @Override
    public ActivitiesRequestExecutor maxResult(int maxResult) {
        super.maxResult(maxResult);
        return this;
    }

    @Override
    public ActivitiesRequestExecutor filter(String query) {
        super.filter(query);
        return this;
    }

    @Override
    public ActivitiesRequestExecutor orderBy(OrderBy orderBy, Order order) {
        super.orderBy(orderBy, order);
        return this;
    }

    @Override
    public ActivitiesRequestExecutor eTag(String eTag) {
        super.eTag(eTag);
        return this;
    }

    @Override
    protected Call<Activities> prepareCall() {
        Call<Activities> call = this.eTag != null ? this.activitiesService.getActivities(this.params(), this.eTag) : this.activitiesService.getActivities(this.params());
        return call;
    }

    @Override
    protected Map<String, String> params() {
        if (this.activitiesIds.isEmpty()) {
            return super.params();
        }
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("activityId", StringUtils.join(this.activitiesIds, ","));
        params.putAll(super.params());
        return params;
    }
}

