/*
 * Decompiled with CFR 0.152.
 */
package com.kontakt.sdk.android.cloud.api.executor.actions;

import com.kontakt.sdk.android.cloud.api.executor.RequestExecutor;
import com.kontakt.sdk.android.cloud.api.service.ActionsService;
import com.kontakt.sdk.android.cloud.exception.KontaktCloudException;
import com.kontakt.sdk.android.cloud.response.CloudCallback;
import com.kontakt.sdk.android.cloud.util.StringUtils;
import com.kontakt.sdk.android.common.Proximity;
import com.kontakt.sdk.android.common.model.Action;
import com.kontakt.sdk.android.common.util.SDKPreconditions;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import retrofit2.Call;

abstract class CreateActionRequestExecutor
extends RequestExecutor<Action> {
    protected final ActionsService actionsService;
    protected String[] uniqueIds;
    protected Action.Type actionType;
    protected Proximity proximity;

    public CreateActionRequestExecutor(ActionsService actionsService) {
        this.actionsService = actionsService;
    }

    public CreateActionRequestExecutor forDevices(String ... uniqueIds) {
        this.uniqueIds = SDKPreconditions.checkNotNull(uniqueIds, "IDs cannot be null");
        return this;
    }

    public CreateActionRequestExecutor forDevices(List<String> uniqueIds) {
        SDKPreconditions.checkNotNull(uniqueIds, "IDs cannot be null");
        int size = uniqueIds.size();
        this.uniqueIds = uniqueIds.toArray(new String[size]);
        return this;
    }

    public CreateActionRequestExecutor withProximity(Proximity proximity) {
        this.proximity = SDKPreconditions.checkNotNull(proximity, "proximity cannot be null");
        return this;
    }

    @Override
    public Action execute() throws IOException, KontaktCloudException {
        this.checkPreconditions();
        return (Action)super.execute();
    }

    @Override
    public void execute(CloudCallback<Action> callback) {
        this.checkPreconditions();
        super.execute(callback);
    }

    @Override
    protected Call<Action> prepareCall() {
        return this.actionsService.createAction(this.params());
    }

    protected abstract void checkPreconditions();

    @Override
    protected Map<String, String> params() {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("uniqueId", StringUtils.join(this.uniqueIds, ","));
        params.put("actionType", this.actionType.name());
        params.put("proximity", this.proximity.name());
        return params;
    }
}

