/*
 * Decompiled with CFR 0.152.
 */
package com.kontakt.sdk.android.cloud.api;

import com.kontakt.sdk.android.cloud.api.executor.activities.ActivitiesRequestExecutor;
import com.kontakt.sdk.android.cloud.api.executor.activities.CreateActivityRequestExecutor;
import com.kontakt.sdk.android.cloud.api.executor.activities.DeleteActivityRequestExecutor;
import com.kontakt.sdk.android.cloud.api.executor.activities.UpdateActivityRequestExecutor;
import com.kontakt.sdk.android.cloud.api.service.ActivitiesService;
import com.kontakt.sdk.android.common.model.Activity;
import com.kontakt.sdk.android.common.util.SDKPreconditions;
import java.util.UUID;

public class ActivitiesApi {
    private final ActivitiesService activitiesService;

    public ActivitiesApi(ActivitiesService activitiesService) {
        this.activitiesService = activitiesService;
    }

    public ActivitiesRequestExecutor fetch() {
        return new ActivitiesRequestExecutor(this.activitiesService);
    }

    public CreateActivityRequestExecutor create(Activity activity) {
        SDKPreconditions.checkNotNull(activity, "Activity cannot be null");
        return new CreateActivityRequestExecutor(this.activitiesService, activity);
    }

    public UpdateActivityRequestExecutor update(UUID id) {
        SDKPreconditions.checkNotNull(id, "ID cannot be null");
        return new UpdateActivityRequestExecutor(this.activitiesService, id);
    }

    public DeleteActivityRequestExecutor delete(UUID id) {
        SDKPreconditions.checkNotNull(id, "ID cannot be null");
        return new DeleteActivityRequestExecutor(this.activitiesService, id);
    }
}

