/*
 * Decompiled with CFR 0.152.
 */
package com.kontakt.sdk.android.ble.service;

import com.kontakt.sdk.android.ble.configuration.ScanContext;
import com.kontakt.sdk.android.ble.manager.listeners.InternalProximityListener;
import com.kontakt.sdk.android.ble.service.ForceScanScheduler;
import com.kontakt.sdk.android.ble.service.ProximityService;
import com.kontakt.sdk.android.ble.service.ScanConfiguration;
import com.kontakt.sdk.android.ble.service.ScanController;
import com.kontakt.sdk.android.common.profile.DeviceProfile;
import java.util.EnumSet;

final class ServiceScanConfiguration {
    static final Item NULL = new Item(new ScanContext.Builder().observedProfiles(EnumSet.of(DeviceProfile.IBEACON, DeviceProfile.EDDYSTONE, DeviceProfile.KONTAKT_SECURE)).build(), ScanConfiguration.NULL, ForceScanScheduler.DISABLED, ScanController.NULL);
    private ProximityService.State state = ProximityService.State.IDLE;
    private Item configurationItem = NULL;

    ServiceScanConfiguration() {
    }

    ProximityService.State getState() {
        return this.state;
    }

    void updateState(ProximityService.State newState) {
        this.state = newState;
    }

    ScanContext getScanContext() {
        return this.configurationItem.scanContext;
    }

    ScanConfiguration getScanConfiguration() {
        return this.configurationItem.scanConfiguration;
    }

    ForceScanScheduler getForceScanScheduler() {
        return this.configurationItem.forceScanScheduler;
    }

    ScanController getScanController() {
        return this.configurationItem.scanController;
    }

    void addListener(InternalProximityListener proximityListener) {
        this.configurationItem.scanConfiguration.addListener(proximityListener);
    }

    void removeListener(InternalProximityListener proximityListener) {
        this.configurationItem.scanConfiguration.removeListener(proximityListener);
    }

    void clear() {
        this.configurationItem = NULL;
        this.state = ProximityService.State.IDLE;
    }

    void add(Item item) {
        this.configurationItem = item;
    }

    Item get() {
        return this.configurationItem;
    }

    Item remove() {
        Item item = this.configurationItem;
        this.state = ProximityService.State.IDLE;
        this.configurationItem = NULL;
        return item;
    }

    static final class Item {
        final ScanContext scanContext;
        final ScanConfiguration scanConfiguration;
        final ForceScanScheduler forceScanScheduler;
        final ScanController scanController;

        Item(ScanContext scanContext, ScanConfiguration scanConfiguration, ForceScanScheduler forceScanScheduler, ScanController scanController) {
            this.scanContext = scanContext;
            this.scanConfiguration = scanConfiguration;
            this.forceScanScheduler = forceScanScheduler;
            this.scanController = scanController;
        }
    }
}

