/*
 * Decompiled with CFR 0.152.
 */
package com.kontakt.sdk.android.ble.discovery;

import com.kontakt.sdk.android.ble.discovery.BluetoothDeviceEvent;
import com.kontakt.sdk.android.ble.discovery.eddystone.EddystoneDeviceEvent;
import com.kontakt.sdk.android.ble.discovery.ibeacon.IBeaconDeviceEvent;
import com.kontakt.sdk.android.ble.discovery.secure_profile.SecureProfileEvent;
import com.kontakt.sdk.android.common.profile.DeviceProfile;
import com.kontakt.sdk.android.common.profile.RemoteBluetoothDevice;
import com.kontakt.sdk.android.common.util.SDKPreconditions;
import com.kontakt.sdk.android.common.util.SecureProfileUtils;
import java.util.List;

public final class DiscoveryUtils {
    private DiscoveryUtils() {
    }

    public static double calculateDistance(int txPower, double rssi, DeviceProfile profile) {
        SDKPreconditions.checkNotNull(profile, "Profile can't be null");
        if (rssi == 0.0) {
            return -1.0;
        }
        int normalizedTxPower = profile == DeviceProfile.EDDYSTONE ? txPower - 41 : txPower;
        double ratio = rssi * 1.0 / (double)normalizedTxPower;
        if (ratio < 1.0) {
            return Math.pow(ratio, 10.0);
        }
        return 0.89976 * Math.pow(ratio, 7.7095) + 0.111;
    }

    static BluetoothDeviceEvent createUpdatedEvent(BluetoothDeviceEvent bluetoothDeviceEvent, List<? extends RemoteBluetoothDevice> devices) {
        switch (bluetoothDeviceEvent.getDeviceProfile()) {
            case IBEACON: {
                IBeaconDeviceEvent iBeaconDeviceEvent = (IBeaconDeviceEvent)bluetoothDeviceEvent;
                List<? extends RemoteBluetoothDevice> iBeaconDevices = devices;
                return IBeaconDeviceEvent.of(iBeaconDeviceEvent, iBeaconDevices);
            }
            case EDDYSTONE: {
                EddystoneDeviceEvent eddystoneDeviceEvent = (EddystoneDeviceEvent)bluetoothDeviceEvent;
                List<? extends RemoteBluetoothDevice> eddystoneDevices = devices;
                return EddystoneDeviceEvent.of(eddystoneDeviceEvent, eddystoneDevices);
            }
            case KONTAKT_SECURE: {
                SecureProfileEvent secureProfileEvent = (SecureProfileEvent)bluetoothDeviceEvent;
                return SecureProfileEvent.of(secureProfileEvent, SecureProfileUtils.fromRemoteBluetoothDevices(devices));
            }
        }
        throw new IllegalArgumentException("Unsupported device profile!");
    }
}

