/*
 * Decompiled with CFR 0.152.
 */
package com.kontakt.sdk.android.ble.discovery;

import android.annotation.TargetApi;
import android.util.SparseLongArray;
import com.android.internal.util.Predicate;
import com.kontakt.sdk.android.ble.cache.FutureShufflesCache;
import com.kontakt.sdk.android.ble.configuration.ScanContext;
import com.kontakt.sdk.android.ble.discovery.BluetoothDeviceDiscoverer;
import com.kontakt.sdk.android.ble.discovery.BluetoothDeviceEvent;
import com.kontakt.sdk.android.ble.discovery.DiscoveryContract;
import com.kontakt.sdk.android.ble.discovery.EventType;
import com.kontakt.sdk.android.ble.discovery.ShuffledDevicesResolver;
import com.kontakt.sdk.android.ble.util.ReplacingArrayList;
import com.kontakt.sdk.android.ble.util.SafeSparseLongArray;
import com.kontakt.sdk.android.common.profile.RemoteBluetoothDevice;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

@TargetApi(value=18)
public abstract class AbstractDeviceDiscoverer<Space, Device extends RemoteBluetoothDevice, Filter extends Predicate<Device>>
implements BluetoothDeviceDiscoverer,
ShuffledDevicesResolver.ResolveCallback {
    private final Map<Space, Long> lastCallbacksTimeMap = new HashMap<Space, Long>();
    private final Map<Space, ReplacingArrayList<Device>> spaceDeviceListMap = new ConcurrentHashMap<Space, ReplacingArrayList<Device>>();
    private final SparseLongArray deviceTimestampArray = new SafeSparseLongArray();
    private final Collection<Filter> filters;
    private final SparseLongArray spaceTimestampArray;
    private final DiscoveryContract discoveryContract;
    private final ShuffledDevicesResolver shuffleResolver;
    private final Collection<Space> spaceSet;
    private final ScanContext scanContext;

    protected AbstractDeviceDiscoverer(DiscoveryContract discoveryContract, ScanContext scanContext, Collection<Space> spaceSet, Collection<Filter> filters, FutureShufflesCache shufflesCache) {
        this.discoveryContract = discoveryContract;
        this.scanContext = scanContext;
        this.spaceSet = spaceSet;
        this.filters = filters;
        this.spaceTimestampArray = new SafeSparseLongArray(spaceSet.size());
        this.shuffleResolver = new ShuffledDevicesResolver(this, shufflesCache);
        this.initCallbacksTimeMap(spaceSet);
    }

    private void initCallbacksTimeMap(Collection<Space> spaceSet) {
        for (Space space : spaceSet) {
            this.lastCallbacksTimeMap.put(space, 0L);
        }
    }

    protected abstract BluetoothDeviceEvent createEvent(EventType var1, Space var2, List<Device> var3);

    protected abstract void onBeforeDeviceLost(Device var1);

    protected abstract void onShuffleResolved(Device var1);

    protected void notifyDevicePresent(int deviceAddressHashcode, long timestamp) {
        this.deviceTimestampArray.put(deviceAddressHashcode, timestamp);
    }

    protected void notifySpacePresent(int spaceHashcode, long timestamp) {
        this.spaceTimestampArray.put(spaceHashcode, timestamp);
    }

    protected Collection<Space> getSpaceSet() {
        return this.spaceSet;
    }

    protected ReplacingArrayList<Device> getDevicesInSpace(Space space) {
        return this.spaceDeviceListMap.get(space);
    }

    protected void resolveShuffled(RemoteBluetoothDevice device) {
        this.shuffleResolver.resolve(device);
    }

    @Override
    public void onResolved(RemoteBluetoothDevice device) {
        this.onShuffleResolved(device);
    }

    protected boolean applyFilters(Device device) {
        if (device == null) {
            return false;
        }
        if (this.filters.isEmpty()) {
            return true;
        }
        for (Predicate filter : this.filters) {
            if (filter.apply(device)) continue;
            return false;
        }
        return true;
    }

    protected void insertDevicesIntoSpace(Space space, ReplacingArrayList<Device> deviceList) {
        this.spaceDeviceListMap.put(space, deviceList);
    }

    protected void onSpaceEnteredEvent(Space space) {
        this.discoveryContract.onEvent(this.createEvent(EventType.SPACE_ENTERED, space, Collections.emptyList()));
    }

    protected void onDeviceDiscoveredEvent(Space space, Device device) {
        this.discoveryContract.onEvent(this.createEvent(EventType.DEVICE_DISCOVERED, space, Collections.singletonList(device)));
    }

    protected void onDevicesUpdatedEvent(Space space, Collection<Device> deviceList) {
        long devicesUpdateCallbackInterval = this.scanContext.getDeviceUpdateCallbackInterval();
        long currentTimeMillis = System.currentTimeMillis();
        if (this.lastCallbacksTimeMap.get(space) + devicesUpdateCallbackInterval > currentTimeMillis) {
            return;
        }
        this.lastCallbacksTimeMap.put(space, currentTimeMillis);
        this.discoveryContract.onEvent(this.createEvent(EventType.DEVICES_UPDATE, space, new ArrayList<Device>(deviceList)));
    }

    void onDeviceLostEvent(Space space, Device device) {
        this.discoveryContract.onEvent(this.createEvent(EventType.DEVICE_LOST, space, Collections.singletonList(device)));
        this.shuffleResolver.onDeviceLost((RemoteBluetoothDevice)device);
    }

    void onSpaceAbandonedEvent(Space space) {
        this.discoveryContract.onEvent(this.createEvent(EventType.SPACE_ABANDONED, space, Collections.emptyList()));
    }

    @Override
    public void evictInactiveDevices(long currentTimeMillis) {
        long inactivityTimeout = this.scanContext.getActivityCheckConfiguration().getInactivityTimeout();
        for (Map.Entry<Space, ReplacingArrayList<Device>> entry : this.spaceDeviceListMap.entrySet()) {
            Space space = entry.getKey();
            Iterator iterator = entry.getValue().iterator();
            while (iterator.hasNext()) {
                long threshold;
                RemoteBluetoothDevice remoteDevice = (RemoteBluetoothDevice)iterator.next();
                long deviceTimestamp = this.deviceTimestampArray.get(remoteDevice.getAddress().hashCode(), -1L);
                if (deviceTimestamp == -1L || (threshold = currentTimeMillis - deviceTimestamp) <= inactivityTimeout) continue;
                iterator.remove();
                this.onBeforeDeviceLost(remoteDevice);
                this.onDeviceLostEvent(space, remoteDevice);
                this.removeDeviceTimestamp(remoteDevice);
            }
        }
        this.evictInactiveRegions(inactivityTimeout, currentTimeMillis);
    }

    private void evictInactiveRegions(long inactivityTimeout, long currentTimeMillis) {
        HashSet<Space> spaces = new HashSet<Space>(this.spaceDeviceListMap.keySet());
        for (Object space : spaces) {
            long threshold;
            long regionTimestamp = this.spaceTimestampArray.get(space.hashCode(), -1L);
            if (regionTimestamp == -1L || (threshold = currentTimeMillis - regionTimestamp) <= inactivityTimeout) continue;
            this.spaceDeviceListMap.remove(space);
            this.onSpaceAbandonedEvent(space);
            this.removeSpaceTimestamp(space);
        }
    }

    private void removeDeviceTimestamp(Device remoteDevice) {
        int index = this.deviceTimestampArray.indexOfKey(remoteDevice.getAddress().hashCode());
        if (index >= 0) {
            this.deviceTimestampArray.removeAt(index);
        }
    }

    private void removeSpaceTimestamp(Space space) {
        int index = this.spaceTimestampArray.indexOfKey(space.hashCode());
        if (index >= 0) {
            this.spaceTimestampArray.removeAt(index);
        }
    }

    @Override
    public void disable() {
        this.shuffleResolver.disable();
    }
}

