/*
 * Decompiled with CFR 0.152.
 */
package com.kontakt.sdk.android.ble.connection;

public class DeviceConnectionError {
    public static final int ERROR_SERVICES_DISCOVERY = 1;
    public static final int ERROR_OVERWRITE_REQUEST = 2;
    public static final int ERROR_AUTHENTICATION = 3;
    public static final int FAILURE_UNKNOWN_BEACON = 4;
    public static final int FAILURE_WRONG_PASSWORD = 7;
    public static final int ERROR_BATCH_WRITE_PROXIMITY_UUID = 8;
    public static final int ERROR_BATCH_WRITE_TX_POWER = 9;
    public static final int ERROR_BATCH_WRITE_MAJOR = 10;
    public static final int ERROR_BATCH_WRITE_MINOR = 11;
    public static final int ERROR_BATCH_WRITE_INTERVAL = 12;
    public static final int ERROR_BATCH_WRITE_PROFILE = 13;
    public static final int ERROR_BATCH_WRITE_NAMESPACE = 14;
    public static final int ERROR_BATCH_WRITE_INSTANCE_ID = 15;
    public static final int ERROR_BATCH_WRITE_URL = 16;
    public static final int ERROR_BATCH_WRITE_NAME = 17;
    public static final int ERROR_BATCH_WRITE_PASSWORD = 18;
    static final int GATT_ERROR_BEGIN = 1000;

    public static boolean isGattError(int errorCode) {
        return errorCode > 1000;
    }

    public static int getGattError(int errorCode) {
        if (!DeviceConnectionError.isGattError(errorCode)) {
            throw new IllegalArgumentException("Error code is not gatt error");
        }
        return errorCode - 1000;
    }

    static int toGattError(int errorCode) {
        return errorCode + 1000;
    }
}

