/*
 * Decompiled with CFR 0.152.
 */
package com.kontakt.sdk.android.ble.configuration;

import android.os.Build;
import com.kontakt.sdk.android.ble.configuration.ActivityCheckConfiguration;
import com.kontakt.sdk.android.ble.configuration.ForceScanConfiguration;
import com.kontakt.sdk.android.ble.configuration.ScanContextValidator;
import com.kontakt.sdk.android.ble.configuration.ScanMode;
import com.kontakt.sdk.android.ble.configuration.ScanPeriod;
import com.kontakt.sdk.android.ble.device.BeaconRegion;
import com.kontakt.sdk.android.ble.device.EddystoneNamespace;
import com.kontakt.sdk.android.ble.filter.eddystone.EddystoneFilter;
import com.kontakt.sdk.android.ble.filter.ibeacon.IBeaconFilter;
import com.kontakt.sdk.android.ble.manager.configuration.FiltersConfigurator;
import com.kontakt.sdk.android.ble.manager.configuration.GeneralConfigurator;
import com.kontakt.sdk.android.ble.manager.configuration.SpacesConfigurator;
import com.kontakt.sdk.android.ble.rssi.RssiCalculator;
import com.kontakt.sdk.android.ble.rssi.RssiCalculators;
import com.kontakt.sdk.android.ble.spec.EddystoneFrameType;
import com.kontakt.sdk.android.common.profile.DeviceProfile;
import com.kontakt.sdk.android.common.profile.IBeaconRegion;
import com.kontakt.sdk.android.common.profile.IEddystoneNamespace;
import com.kontakt.sdk.android.common.util.SDKPreconditions;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;

public class ScanContext {
    public static final ScanContext DEFAULT = new Builder().build();
    public static final int MIN_RESOLVE_INTERVAL = 0;
    public static final int MIN_MONITORING_SYNC_INTERVAL = 0;
    public static final String FILE_NAME_REGEX = "^[^(^?|*<\":>+\\[\\]\\/'{})]+$";
    public static final Pattern FILE_NAME_MATCHER = Pattern.compile("^[^(^?|*<\":>+\\[\\]\\/'{})]+$");
    public static final long DEFAULT_DEVICES_UPDATE_CALLBACK_INTERVAL = 3000L;
    public static final String DEFAULT_CACHE_FILE_NAME = "resolved.che";
    public static final int DEFAULT_RESOLVE_INTERVAL = 3;
    public static final int DEFAULT_MONITORING_SYNC_INTERVAL = 10;
    public static final boolean DEFAULT_MONITORING_ENABLED = true;
    private final ScanPeriod scanPeriod;
    private final ScanMode scanMode;
    private final ActivityCheckConfiguration activityCheckConfiguration;
    private final ForceScanConfiguration forceScanConfiguration;
    private final RssiCalculator rssiCalculator;
    private final Set<IBeaconRegion> iBeaconRegions;
    private final Set<IEddystoneNamespace> eddystoneNamespaces;
    private final Set<EddystoneFrameType> eddystoneTriggerFrameTypes;
    private final List<IBeaconFilter> iBeaconFilters;
    private final List<EddystoneFilter> eddystoneFilters;
    private final Set<DeviceProfile> observedProfiles;
    private final String cacheFileName;
    private final int resolveInterval;
    private final int monitoringSyncInterval;
    private final boolean monitoringEnabled;
    private final long deviceUpdateCallbackInterval;

    ScanContext(Builder builder) {
        this.forceScanConfiguration = builder.forceScanConfiguration;
        this.scanPeriod = builder.scanPeriod;
        this.scanMode = builder.scanMode;
        this.activityCheckConfiguration = builder.activityCheckConfiguration;
        this.deviceUpdateCallbackInterval = builder.deviceUpdateCallbackInterval;
        this.rssiCalculator = builder.rssiCalculator;
        this.observedProfiles = builder.observedProfiles;
        this.eddystoneTriggerFrameTypes = builder.eddystoneTriggerFrameTypes;
        this.iBeaconRegions = builder.iBeaconRegions;
        this.eddystoneNamespaces = builder.eddystoneNamespaces;
        this.iBeaconFilters = builder.iBeaconFilters;
        this.eddystoneFilters = builder.eddystoneFilters;
        this.cacheFileName = builder.cacheFileName;
        this.resolveInterval = builder.resolveInterval;
        this.monitoringSyncInterval = builder.monitoringSyncInterval;
        this.monitoringEnabled = builder.monitoringEnabled;
    }

    public ActivityCheckConfiguration getActivityCheckConfiguration() {
        return this.activityCheckConfiguration;
    }

    public Set<DeviceProfile> getObservedProfiles() {
        return this.observedProfiles;
    }

    public ForceScanConfiguration getForceScanConfiguration() {
        return this.forceScanConfiguration;
    }

    public ScanPeriod getScanPeriod() {
        return this.scanPeriod;
    }

    public ScanMode getScanMode() {
        return this.scanMode;
    }

    public long getDeviceUpdateCallbackInterval() {
        return this.deviceUpdateCallbackInterval;
    }

    public RssiCalculator getRssiCalculator() {
        return this.rssiCalculator;
    }

    public Set<EddystoneFrameType> getEddystoneFrameTypes() {
        return this.eddystoneTriggerFrameTypes;
    }

    public Set<IBeaconRegion> getIBeaconRegions() {
        return this.iBeaconRegions;
    }

    public Set<IEddystoneNamespace> getEddystoneNamespaces() {
        return this.eddystoneNamespaces;
    }

    public List<IBeaconFilter> getIBeaconFilters() {
        return this.iBeaconFilters;
    }

    public List<EddystoneFilter> getEddystoneFilters() {
        return this.eddystoneFilters;
    }

    public String getCacheFileName() {
        return this.cacheFileName;
    }

    public int getResolveInterval() {
        return this.resolveInterval;
    }

    public int getMonitoringSyncInterval() {
        return this.monitoringSyncInterval;
    }

    public boolean isMonitoringEnabled() {
        return this.monitoringEnabled;
    }

    public static final class Builder
    implements GeneralConfigurator,
    SpacesConfigurator,
    FiltersConfigurator {
        ScanMode scanMode = ScanMode.BALANCED;
        ScanPeriod scanPeriod = ScanPeriod.RANGING;
        ForceScanConfiguration forceScanConfiguration = ForceScanConfiguration.DISABLED;
        ActivityCheckConfiguration activityCheckConfiguration = ActivityCheckConfiguration.DEFAULT;
        RssiCalculator rssiCalculator = RssiCalculators.DEFAULT;
        Set<DeviceProfile> observedProfiles = EnumSet.allOf(DeviceProfile.class);
        Set<EddystoneFrameType> eddystoneTriggerFrameTypes = EnumSet.noneOf(EddystoneFrameType.class);
        Set<IBeaconRegion> iBeaconRegions = new HashSet<IBeaconRegion>();
        Set<IEddystoneNamespace> eddystoneNamespaces = new HashSet<IEddystoneNamespace>();
        List<IBeaconFilter> iBeaconFilters = new ArrayList<IBeaconFilter>();
        List<EddystoneFilter> eddystoneFilters = new ArrayList<EddystoneFilter>();
        int resolveInterval = 3;
        int monitoringSyncInterval = 10;
        long deviceUpdateCallbackInterval = 3000L;
        boolean monitoringEnabled = true;
        String cacheFileName = "resolved.che";

        public Builder() {
        }

        public Builder(ScanContext context) {
            this.scanMode = context.getScanMode();
            this.scanPeriod = context.getScanPeriod();
            this.forceScanConfiguration = context.getForceScanConfiguration();
            this.activityCheckConfiguration = context.getActivityCheckConfiguration();
            this.deviceUpdateCallbackInterval = context.getDeviceUpdateCallbackInterval();
            this.rssiCalculator = context.getRssiCalculator();
            this.observedProfiles = context.getObservedProfiles();
            this.iBeaconRegions = context.getIBeaconRegions();
            this.iBeaconFilters = context.getIBeaconFilters();
            this.eddystoneNamespaces = context.getEddystoneNamespaces();
            this.eddystoneFilters = context.getEddystoneFilters();
            this.eddystoneTriggerFrameTypes = context.getEddystoneFrameTypes();
            this.cacheFileName = context.getCacheFileName();
            this.resolveInterval = context.getResolveInterval();
            this.monitoringSyncInterval = context.getMonitoringSyncInterval();
            this.monitoringEnabled = context.isMonitoringEnabled();
        }

        @Override
        public GeneralConfigurator scanPeriod(ScanPeriod scanPeriod) {
            SDKPreconditions.checkNotNull(scanPeriod, "Monitor period cannot be null");
            this.scanPeriod = scanPeriod;
            return this;
        }

        @Override
        public GeneralConfigurator scanMode(ScanMode scanMode) {
            SDKPreconditions.checkNotNull(scanMode, "Scan mode is null");
            this.scanMode = scanMode;
            return this;
        }

        @Override
        public GeneralConfigurator forceScanConfiguration(ForceScanConfiguration forceScanConfiguration) {
            SDKPreconditions.checkNotNull(forceScanConfiguration, "By default ForceScanConfiguration is disabled");
            this.forceScanConfiguration = Build.VERSION.SDK_INT >= 24 ? ForceScanConfiguration.DISABLED : forceScanConfiguration;
            return this;
        }

        @Override
        public GeneralConfigurator activityCheckConfiguration(ActivityCheckConfiguration activityCheckConfiguration) {
            SDKPreconditions.checkNotNull(activityCheckConfiguration, "Beacon activity check is null.");
            this.activityCheckConfiguration = activityCheckConfiguration;
            return this;
        }

        @Override
        public GeneralConfigurator cacheFileName(String name) {
            SDKPreconditions.checkNotNull(name, "Cache file name cannot be null!");
            boolean match = FILE_NAME_MATCHER.matcher(name).matches();
            SDKPreconditions.checkArgument(match, "Incorrect cache file name");
            this.cacheFileName = name;
            return this;
        }

        @Override
        public GeneralConfigurator monitoringEnabled(boolean enabled) {
            this.monitoringEnabled = enabled;
            return this;
        }

        @Override
        public GeneralConfigurator monitoringSyncInterval(int intervalInSeconds) {
            SDKPreconditions.checkArgument(intervalInSeconds > 0, "Monitoring sync interval must be greater than 0!");
            this.monitoringSyncInterval = intervalInSeconds;
            return this;
        }

        @Override
        public GeneralConfigurator resolveShuffledInterval(int intervalInSeconds) {
            SDKPreconditions.checkArgument(intervalInSeconds > 0, "Resolve interval must be greater than 0!");
            this.resolveInterval = intervalInSeconds;
            return this;
        }

        @Override
        public GeneralConfigurator deviceUpdateCallbackInterval(long intervalInMillis) {
            SDKPreconditions.checkArgument(intervalInMillis > 0L, "Interval must be greater than 0");
            this.deviceUpdateCallbackInterval = intervalInMillis;
            return this;
        }

        @Override
        public GeneralConfigurator rssiCalculator(RssiCalculator rssiCalculator) {
            SDKPreconditions.checkNotNull(rssiCalculator, "RssiCalculator can't be null");
            this.rssiCalculator = rssiCalculator;
            return this;
        }

        @Override
        public GeneralConfigurator eddystoneFrameTypes(Collection<EddystoneFrameType> eddystoneFrameTypes) {
            SDKPreconditions.checkNotNull(eddystoneFrameTypes, "Eddystone trigger frames");
            this.eddystoneTriggerFrameTypes.clear();
            this.eddystoneTriggerFrameTypes.addAll(eddystoneFrameTypes);
            return this;
        }

        @Override
        public SpacesConfigurator iBeaconRegion(IBeaconRegion region) {
            SDKPreconditions.checkNotNull(region);
            this.iBeaconRegions(Collections.singletonList(region));
            return this;
        }

        @Override
        public SpacesConfigurator iBeaconRegions(Collection<IBeaconRegion> regions) {
            SDKPreconditions.checkNotNull(regions, "Regions collection is null");
            this.iBeaconRegions.clear();
            this.iBeaconRegions.addAll(regions);
            return this;
        }

        @Override
        public SpacesConfigurator eddystoneNamespace(IEddystoneNamespace namespace) {
            SDKPreconditions.checkNotNull(namespace);
            this.eddystoneNamespaces(Collections.singletonList(namespace));
            return this;
        }

        @Override
        public SpacesConfigurator eddystoneNamespaces(Collection<IEddystoneNamespace> namespaces) {
            SDKPreconditions.checkNotNull(namespaces, "Eddystone namespaces are null.");
            this.eddystoneNamespaces.clear();
            this.eddystoneNamespaces.addAll(namespaces);
            return this;
        }

        @Override
        public FiltersConfigurator iBeaconFilter(IBeaconFilter filter) {
            SDKPreconditions.checkNotNull(filter);
            this.iBeaconFilters(Collections.singletonList(filter));
            return this;
        }

        @Override
        public FiltersConfigurator iBeaconFilters(Collection<IBeaconFilter> filters) {
            SDKPreconditions.checkNotNull(filters, "Filters are null.");
            this.iBeaconFilters.clear();
            this.iBeaconFilters.addAll(filters);
            return this;
        }

        @Override
        public FiltersConfigurator eddystoneFilter(EddystoneFilter filter) {
            SDKPreconditions.checkNotNull(filter);
            this.eddystoneFilters(Collections.singletonList(filter));
            return this;
        }

        @Override
        public FiltersConfigurator eddystoneFilters(Collection<EddystoneFilter> filters) {
            SDKPreconditions.checkNotNull(filters, "Filters are null.");
            this.eddystoneFilters.clear();
            this.eddystoneFilters.addAll(filters);
            return this;
        }

        @Override
        public void clearAll() {
            this.iBeaconFilters(Collections.emptyList());
            this.eddystoneFilters(Collections.emptyList());
        }

        public Builder observedProfiles(Set<DeviceProfile> observedProfiles) {
            SDKPreconditions.checkNotNull(observedProfiles, "Observed profiles can't be null");
            this.observedProfiles = observedProfiles;
            return this;
        }

        public Builder addObservedProfile(DeviceProfile profile) {
            SDKPreconditions.checkNotNull(profile, "Observed profiles can't be null");
            this.observedProfiles.add(profile);
            return this;
        }

        public Builder removeObservedProfile(DeviceProfile profile) {
            SDKPreconditions.checkNotNull(profile, "Observed profiles can't be null");
            this.observedProfiles.remove((Object)profile);
            return this;
        }

        public ScanContext build() {
            SDKPreconditions.checkNotNullOrEmpty(this.observedProfiles, "At least one listener (IBeacon or Eddystone or Kontakt Secure Profile) must be set.");
            ScanContextValidator.validate(this.scanPeriod);
            ScanContextValidator.validateEddystoneFiltersCount(this.eddystoneFilters);
            ScanContextValidator.validateIBeaconFiltersCount(this.iBeaconFilters);
            ScanContextValidator.validateIBeaconRegionsCount(this.iBeaconRegions);
            ScanContextValidator.validateNamespacesCount(this.eddystoneNamespaces);
            ScanContextValidator.validate(this.activityCheckConfiguration);
            ScanContextValidator.validate(this.forceScanConfiguration);
            ScanContextValidator.validate(this.activityCheckConfiguration, this.scanPeriod);
            if (this.iBeaconRegions.isEmpty()) {
                this.iBeaconRegions.add(BeaconRegion.EVERYWHERE);
            }
            if (this.eddystoneNamespaces.isEmpty()) {
                this.eddystoneNamespaces.add(EddystoneNamespace.EVERYWHERE);
            }
            return new ScanContext(this);
        }
    }
}

