/*
 * Decompiled with CFR 0.152.
 */
package com.kontakt.sdk.android.ble.cache;

import com.kontakt.sdk.android.ble.cache.FutureShufflesCache;
import com.kontakt.sdk.android.ble.cache.ResolveRequestStatus;
import com.kontakt.sdk.android.ble.cache.ResolverType;
import com.kontakt.sdk.android.ble.cache.SecureProfileApiResolveStrategy;
import com.kontakt.sdk.android.ble.cache.SecureProfileCacheResolveStrategy;
import com.kontakt.sdk.android.ble.cache.SecureProfileResolveRequest;
import com.kontakt.sdk.android.ble.cache.SecureProfileResolveStrategy;
import com.kontakt.sdk.android.ble.device.SecureProfile;
import com.kontakt.sdk.android.cloud.KontaktCloud;
import com.kontakt.sdk.android.common.log.Logger;
import com.kontakt.sdk.android.common.model.ResolvedId;
import com.kontakt.sdk.android.common.model.SecureProfileFutureUID;
import com.kontakt.sdk.android.common.model.SecureProfileUid;
import com.kontakt.sdk.android.common.profile.DeviceProfile;
import com.kontakt.sdk.android.common.profile.ISecureProfile;
import com.kontakt.sdk.android.common.profile.RemoteBluetoothDevice;
import com.kontakt.sdk.android.common.util.SecureProfileUtils;
import java.net.SocketTimeoutException;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ArrayBlockingQueue;

class SecureProfileResolver
implements Runnable {
    private static final String TAG = "SecureProfileResolver";
    private static final int REQUEST_UNIT_SIZE = 120;
    private static final int DEFAULT_BUFFER_SIZE = 200;
    private static final DeviceProfile DEVICE_PROFILE = DeviceProfile.KONTAKT_SECURE;
    private final ArrayBlockingQueue<SecureProfileResolveRequest> requestQueue;
    private final FutureShufflesCache cache;
    private final Collection<SecureProfileResolveStrategy> strategies;

    SecureProfileResolver(FutureShufflesCache futureShufflesCache, KontaktCloud kontaktCloud) {
        this.cache = futureShufflesCache;
        this.requestQueue = new ArrayBlockingQueue(200, true);
        LinkedList<SecureProfileResolveStrategy> resolvers = new LinkedList<SecureProfileResolveStrategy>();
        SecureProfileCacheResolveStrategy cacheStrategy = new SecureProfileCacheResolveStrategy(this.cache);
        SecureProfileApiResolveStrategy apiStrategy = new SecureProfileApiResolveStrategy(kontaktCloud);
        resolvers.add(cacheStrategy);
        resolvers.add(apiStrategy);
        this.strategies = Collections.unmodifiableCollection(resolvers);
    }

    @Override
    public void run() {
        if (!this.cache.isInitialized()) {
            Logger.d("SecureProfileResolver Cache not initialized yet");
            return;
        }
        ArrayList<SecureProfileResolveRequest> requests = new ArrayList<SecureProfileResolveRequest>();
        this.requestQueue.drainTo(requests, 120);
        if (requests.isEmpty()) {
            Logger.d("SecureProfileResolver Nothing to resolve");
            return;
        }
        try {
            Logger.d("SecureProfileResolver Start resolving");
            Map<SecureProfileUid, SecureProfileResolveRequest> requestsRegister = this.buildRequestsRegister(requests);
            List<SecureProfileFutureUID> shuffles = this.resolveShuffles(requestsRegister);
            Map<SecureProfileUid, SecureProfileFutureUID> shufflesRegister = this.buildShufflesRegister(shuffles);
            this.evictOutdatedCacheEntries(requestsRegister, shufflesRegister);
            this.handleRequests(requestsRegister, shufflesRegister);
            this.cache.serialize();
        }
        catch (Exception e) {
            Throwable cause = e.getCause();
            if (UnknownHostException.class.isInstance(cause) || SocketTimeoutException.class.isInstance(cause)) {
                this.requestQueue.addAll(requests);
            }
            Logger.e("SecureProfileResolver Error occurs when try to resolve shuffled device ", e);
        }
    }

    void addResolveRequest(SecureProfileResolveRequest request) {
        if (this.requestQueue.contains(request)) {
            return;
        }
        try {
            this.requestQueue.add(request);
        }
        catch (IllegalStateException fullQueueException) {
            Logger.e("Could not add Secure Profiles to resolve", fullQueueException);
        }
    }

    public void markIgnored(RemoteBluetoothDevice beacon) {
        for (SecureProfileResolveRequest request : this.requestQueue) {
            if (!request.getFakeDevice().equals(beacon)) continue;
            request.setStatus(ResolveRequestStatus.IGNORED);
        }
    }

    public void clear() {
        this.requestQueue.clear();
    }

    private Map<SecureProfileUid, SecureProfileResolveRequest> buildRequestsRegister(List<SecureProfileResolveRequest> requests) {
        HashMap<SecureProfileUid, SecureProfileResolveRequest> requestsRegister = new HashMap<SecureProfileUid, SecureProfileResolveRequest>();
        for (SecureProfileResolveRequest request : requests) {
            SecureProfileUid secureProfileUid = SecureProfileUid.fromDevice(request.getFakeDevice());
            requestsRegister.put(secureProfileUid, request);
        }
        return requestsRegister;
    }

    private List<SecureProfileFutureUID> resolveShuffles(Map<SecureProfileUid, SecureProfileResolveRequest> requestsRegister) throws Exception {
        ArrayList<SecureProfileFutureUID> shuffles = new ArrayList<SecureProfileFutureUID>();
        for (SecureProfileResolveStrategy strategy : this.strategies) {
            List<SecureProfileFutureUID> resolved = strategy.resolve(requestsRegister);
            shuffles.addAll(resolved);
        }
        return shuffles;
    }

    private Map<SecureProfileUid, SecureProfileFutureUID> buildShufflesRegister(List<SecureProfileFutureUID> shuffles) {
        HashMap<SecureProfileUid, SecureProfileFutureUID> shufflesRegister = new HashMap<SecureProfileUid, SecureProfileFutureUID>();
        for (SecureProfileFutureUID futureShuffle : shuffles) {
            shufflesRegister.put(futureShuffle.getQueriedBy(), futureShuffle);
        }
        return shufflesRegister;
    }

    private void evictOutdatedCacheEntries(Map<SecureProfileUid, SecureProfileResolveRequest> requestsRegister, Map<SecureProfileUid, SecureProfileFutureUID> shufflesRegister) {
        ArrayList<String> uniqueIds = new ArrayList<String>();
        for (Map.Entry<SecureProfileUid, SecureProfileResolveRequest> entry : requestsRegister.entrySet()) {
            SecureProfileUid queriedBy = entry.getKey();
            SecureProfileResolveRequest request = entry.getValue();
            SecureProfileFutureUID futureUID = shufflesRegister.get(queriedBy);
            if (futureUID == null || ResolverType.CACHE == request.getResolvedBy()) continue;
            uniqueIds.add(futureUID.getUniqueId());
        }
        this.cache.evict(uniqueIds, DEVICE_PROFILE);
    }

    private void handleRequests(Map<SecureProfileUid, SecureProfileResolveRequest> requestsRegister, Map<SecureProfileUid, SecureProfileFutureUID> shufflesRegister) {
        for (Map.Entry<SecureProfileUid, SecureProfileResolveRequest> entry : requestsRegister.entrySet()) {
            this.handleRequest(shufflesRegister, entry);
        }
    }

    private void handleRequest(Map<SecureProfileUid, SecureProfileFutureUID> shufflesRegister, Map.Entry<SecureProfileUid, SecureProfileResolveRequest> entry) {
        SecureProfileUid queriedBy = entry.getKey();
        SecureProfileFutureUID futureUID = shufflesRegister.get(queriedBy);
        if (futureUID == null) {
            this.cache.populate(queriedBy.toString(), FutureShufflesCache.PHANTOM_ENTRY);
            return;
        }
        SecureProfileUid resolvedId = futureUID.getResolved();
        SecureProfileResolveRequest request = entry.getValue();
        String uniqueId = futureUID.getUniqueId();
        ResolvedId resolvedProfileUID = ResolvedId.create(resolvedId.toString(), uniqueId, DEVICE_PROFILE);
        if (ResolverType.CACHE != request.getResolvedBy()) {
            this.addNewCacheEntries(futureUID, resolvedProfileUID);
        }
        if (ResolveRequestStatus.RESOLVED == request.getStatus()) {
            this.notifyListeners(request, resolvedProfileUID);
        }
    }

    private void addNewCacheEntries(SecureProfileFutureUID futureUID, ResolvedId resolvedId) {
        for (SecureProfileUid futureShuffle : futureUID.getFutureIds()) {
            this.cache.populate(futureShuffle.toString(), resolvedId);
        }
        this.cache.populate(resolvedId.getSecureProfileUID().toString(), resolvedId);
    }

    private void notifyListeners(SecureProfileResolveRequest request, ResolvedId resolvedId) {
        ISecureProfile fakeDevice = request.getFakeDevice();
        SecureProfile resolvedDevice = new SecureProfile.Builder(fakeDevice).resolvedId(resolvedId).build();
        this.cache.notifyListeners(SecureProfileUtils.asRemoteBluetoothDevice(resolvedDevice));
    }
}

