package com.kontakt.sdk.android.ble.service;

import android.annotation.TargetApi;
import android.bluetooth.BluetoothAdapter;
import android.os.Build;
import com.kontakt.sdk.android.ble.cache.FutureShufflesCache;
import com.kontakt.sdk.android.ble.configuration.ForceScanConfiguration;
import com.kontakt.sdk.android.ble.configuration.ScanContext;
import com.kontakt.sdk.android.ble.monitoring.IEventCollector;
import com.kontakt.sdk.android.common.log.Logger;
import com.kontakt.sdk.android.common.util.Closeables;

@TargetApi(Build.VERSION_CODES.JELLY_BEAN_MR2)
final class ScanCompatJB extends ScanCompat {

  public ScanConfiguration createScanConfiguration(ScanContext scanContext, FutureShufflesCache cache, IEventCollector eventCollector) {
    final BleScanCallback scanCallback = Callbacks.newCallback(scanContext, cache, eventCollector);
    return new AbstractScanConfiguration(scanContext, scanCallback) {
    };
  }

  public ScanController createScanController(ScanConfiguration configuration, ForceScanScheduler forceScanScheduler) {
    return new ScanController.Builder().setScanActiveRunner(Runners.newRunner(Runners.RunnerType.MONITOR_ACTIVE_RUNNER, configuration))
        .setScanPassiveRunner(Runners.newRunner(Runners.RunnerType.MONITOR_PASSIVE_RUNNER, configuration))
        .setScanPeriod(configuration.getScanContext().getScanPeriod())
        .setForceScanScheduler(forceScanScheduler)
        .build();
  }

  public ForceScanScheduler createForceScanScheduler(final ScanConfiguration configuration) {
    final ScanContext scanContext = configuration.getScanContext();

    if (scanContext.getForceScanConfiguration() == ForceScanConfiguration.DISABLED) {
      return ForceScanScheduler.DISABLED;
    }
    return new ForceScanScheduler(Runners.newRunner(Runners.RunnerType.FORCE_SCAN_RUNNER, configuration));
  }

  @SuppressWarnings("MissingPermission")
  @TargetApi(Build.VERSION_CODES.JELLY_BEAN_MR2)
  public void onScanStart(final ScanConfiguration configuration) {
    final BluetoothAdapter.LeScanCallback scanCallback = configuration.getScanCallback();
    final BluetoothAdapter adapter = BluetoothAdapter.getDefaultAdapter();
    if (adapter != null) {
      adapter.startLeScan(scanCallback);
    } else {
      Logger.d("Scan start requested but Bluetooth Adapter is null.");
    }
  }

  @SuppressWarnings("MissingPermission")
  public void onScanStop(BleScanCallback callback) {
    final BluetoothAdapter adapter = BluetoothAdapter.getDefaultAdapter();
    if (adapter != null) {
      adapter.stopLeScan(callback);
    }
    Closeables.closeQuietly(callback);
  }
}
