package com.kontakt.sdk.android.ble.security.property;

import static com.kontakt.sdk.android.common.util.SDKPreconditions.checkArgument;

public class TerminatingProperty extends AbstractProperty<Void> {

  public TerminatingProperty() {
    super(PropertyID.TERMINATING);
  }

  public TerminatingProperty(PropertyID id, byte[] value) {
    super(id);
    checkArgument(value.length == 0);
  }

  @Override
  public byte[] getBytes() {
    return new byte[0];
  }

  @Override
  public byte getSize() {
    return 0;
  }

  @Override
  public Void getValue() {
    return null;
  }
}
