package com.kontakt.sdk.android.ble.filter.ibeacon;

import com.kontakt.sdk.android.common.profile.IBeaconDevice;
import com.kontakt.sdk.android.common.util.SDKPreconditions;

/**
 * A predicate accepting iBeacon device with specific firmware version.
 */
public final class FirmwareFilter implements IBeaconFilter {

  private final String firmwareVersion;

  public FirmwareFilter(final String firmwareVersion) {
    SDKPreconditions.checkNotNull(firmwareVersion, "Firmware version cannot be null");
    this.firmwareVersion = firmwareVersion;
  }

  /**
   * Gets firmware version.
   *
   * @return the firmware version
   */
  public String getFirmwareVersion() {
    return firmwareVersion;
  }

  @Override
  public boolean apply(IBeaconDevice target) {
    return firmwareVersion.equals(target.getFirmwareVersion());
  }
}
