/*
 * Decompiled with CFR 0.152.
 */
package com.kontakt.sdk.android.common.model;

import android.os.Parcel;
import android.os.Parcelable;
import com.kontakt.sdk.android.common.model.EddystoneUid;
import com.kontakt.sdk.android.common.profile.ISecureProfile;
import com.kontakt.sdk.android.common.util.HashCodeBuilder;
import com.kontakt.sdk.android.common.util.SDKEqualsBuilder;
import com.kontakt.sdk.android.common.util.SDKPreconditions;

public class SecureProfileUid
implements Parcelable {
    public static final Parcelable.Creator<SecureProfileUid> CREATOR = new Parcelable.Creator<SecureProfileUid>(){

        public SecureProfileUid createFromParcel(Parcel source) {
            return new SecureProfileUid(source);
        }

        public SecureProfileUid[] newArray(int size) {
            return new SecureProfileUid[size];
        }
    };
    private final String namespace;
    private final String instanceId;

    public static SecureProfileUid of(String namespace, String instanceId) {
        return new SecureProfileUid(namespace, instanceId);
    }

    public static SecureProfileUid fromDevice(ISecureProfile fakeDevice) {
        SDKPreconditions.checkNotNull(fakeDevice, "device cannot be null");
        return new SecureProfileUid(fakeDevice.getNamespace(), fakeDevice.getInstanceId());
    }

    public static SecureProfileUid fromEddystoneUid(EddystoneUid eddystoneUid) {
        SDKPreconditions.checkNotNull(eddystoneUid, "EddystoneUid cannot be null");
        return new SecureProfileUid(eddystoneUid.getNamespace(), eddystoneUid.getInstanceId());
    }

    public static SecureProfileUid fromQueriedBy(String queriedBy) {
        SDKPreconditions.checkNotNull(queriedBy, "queriedBy is null");
        String[] split = queriedBy.split(":");
        if (split.length != 2) {
            throw new IllegalArgumentException("queriedBy has invalid format");
        }
        String namespace = split[0];
        String instanceId = split[1];
        return new SecureProfileUid(namespace, instanceId);
    }

    private SecureProfileUid(String namespace, String instanceId) {
        this.namespace = namespace;
        this.instanceId = instanceId;
    }

    protected SecureProfileUid(Parcel in) {
        this.namespace = in.readString();
        this.instanceId = in.readString();
    }

    public String getNamespace() {
        return this.namespace;
    }

    public String getInstanceId() {
        return this.instanceId;
    }

    public String toString() {
        return this.namespace + ":" + this.instanceId;
    }

    public boolean equals(Object o) {
        if (o == null || !(o instanceof SecureProfileUid)) {
            return false;
        }
        if (o == this) {
            return true;
        }
        SecureProfileUid eddystoneUid = (SecureProfileUid)o;
        return SDKEqualsBuilder.start().equals(this.namespace, eddystoneUid.namespace).equals(this.instanceId, eddystoneUid.instanceId).result();
    }

    public int hashCode() {
        return HashCodeBuilder.init().append(this.namespace).append(this.instanceId).build();
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        dest.writeString(this.namespace);
        dest.writeString(this.instanceId);
    }
}

