/*
 * Decompiled with CFR 0.152.
 */
package com.kontakt.sdk.android.common.model;

import android.os.Parcel;
import android.os.Parcelable;
import com.kontakt.sdk.android.common.model.Event;
import com.kontakt.sdk.android.common.model.SourceType;
import com.kontakt.sdk.android.common.util.SDKPreconditions;
import java.util.ArrayList;
import java.util.List;

public class EventPacket
implements Parcelable {
    public static final Parcelable.Creator<EventPacket> CREATOR = new Parcelable.Creator<EventPacket>(){

        public EventPacket createFromParcel(Parcel source) {
            return new EventPacket(source);
        }

        public EventPacket[] newArray(int size) {
            return new EventPacket[size];
        }
    };
    private String sourceId;
    private SourceType sourceType;
    private long timestamp;
    private List<Event> events = new ArrayList<Event>();

    public static Builder builder() {
        return new Builder();
    }

    public static EventPacket from(List<Event> events, long timestamp) {
        SDKPreconditions.checkNotNull(events, "events cannot be null");
        return new EventPacket(events, timestamp);
    }

    private EventPacket(List<Event> events, long timestamp) {
        this.events = events;
        this.timestamp = timestamp / 1000L;
    }

    EventPacket(Builder builder) {
        this.sourceId = builder.sourceId;
        this.sourceType = builder.sourceType;
        this.timestamp = builder.timestamp / 1000L;
        this.events = builder.events;
    }

    protected EventPacket(Parcel in) {
        this.sourceId = in.readString();
        int tmpSourceType = in.readInt();
        this.sourceType = tmpSourceType == -1 ? null : SourceType.values()[tmpSourceType];
        this.timestamp = in.readLong();
        this.events = in.createTypedArrayList(Event.CREATOR);
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        dest.writeString(this.sourceId);
        dest.writeInt(this.sourceType == null ? -1 : this.sourceType.ordinal());
        dest.writeLong(this.timestamp);
        dest.writeTypedList(this.events);
    }

    public String getSourceId() {
        return this.sourceId;
    }

    public SourceType getSourceType() {
        return this.sourceType;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public List<Event> getEvents() {
        return this.events;
    }

    public static class Builder {
        String sourceId;
        SourceType sourceType;
        long timestamp;
        List<Event> events = new ArrayList<Event>();

        public Builder sourceId(String sourceId) {
            this.sourceId = sourceId;
            return this;
        }

        public Builder sourceType(SourceType sourceType) {
            this.sourceType = sourceType;
            return this;
        }

        public Builder timestamp(long timestamp) {
            this.timestamp = timestamp;
            return this;
        }

        public Builder events(List<Event> events) {
            this.events = events;
            return this;
        }

        public EventPacket build() {
            return new EventPacket(this);
        }
    }
}

