/*
 * Decompiled with CFR 0.152.
 */
package com.kontakt.sdk.android.ble.spec;

import java.util.UUID;

public enum KontaktDeviceService {
    GENERIC_ACCESS("00001800-0000-1000-8000-00805f9b34fb", "Generic Access"),
    GENERIC_ATTRIBUTE("00001801-0000-1000-8000-00805f9b34fb", "Generic Attribute"),
    DEVICE_INFORMATION("0000180a-0000-1000-8000-00805f9b34fb", "Device Information"),
    CURRENT_TIME("00001805-0000-1000-8000-00805f9b34fb", "Current Time"),
    TX_POWER("00001804-0000-1000-8000-00805f9b34fb", "TxPower"),
    BATTERY_LEVEL("0000180f-0000-1000-8000-00805f9b34fb", "Battery Service"),
    PROXIMITY("a1ea8110-0e1b-d4a1-b840-63f88c8da1ea", "Proximity Service"),
    TIMERS("a1ea8120-0e1b-d4a1-b840-63f88c8da1ea", "Timers"),
    CONTROL("a1ea8130-0e1b-d4a1-b840-63f88c8da1ea", "Control Service"),
    DFU_SERVICE("00001530-1212-efde-1523-785feabcd123", "Firmware upgrade Service"),
    SENSORS_SERVICE("a1ea8210-0e1b-d4a1-b840-63f88c8da1ea", "Sensors service"),
    KONTAKT_SENSORS_SERVICE("e04a8f70-d020-fc8e-4f45-c2e225fcaf89", "Kontakt Sensors service"),
    SECURE_CONFIGURATION_SERVICE("A1EA81F0-0E1B-D4A1-B840-63F88C8DA1EA", "Secure config service"),
    KONTAKT_DFU_SERVICE("1b314d70-6c97-43fc-b5dd-3d0e125e15fb", "Kontakt DFU (KDFU) Service");

    private final UUID id;
    private final String name;

    private KontaktDeviceService(String uuidString, String name) {
        this.name = name;
        this.id = UUID.fromString(uuidString);
    }

    public UUID getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public static KontaktDeviceService valueOf(UUID id) {
        for (KontaktDeviceService value : KontaktDeviceService.values()) {
            if (!value.getId().equals(id)) continue;
            return value;
        }
        return null;
    }
}

